/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.screenhandler.v1;

import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_437;

/**
 * An API for registering handled screens that represent screen handlers on the client.
 * Exposes vanilla's private {@link class_3929#method_17542 HandledScreens.register()} to modders as {@link #register ScreenRegistry.register()}.
 *
 * <h2>Example</h2>
 * <pre>
 * {@code
 * // In a client-side initialization method:
 * ScreenRegistry.register(MyScreenHandlers.OVEN, OvenScreen::new);
 *
 * // Screen class
 * public class OvenScreen extends HandledScreen<OvenScreenHandler> {
 * 	public OvenScreen(OvenScreenHandler handler, PlayerInventory inventory, Text title) {
 * 		super(handler, inventory, title);
 * 	}
 * }
 * }
 * </pre>
 *
 * @see net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry registering screen handlers
 * @deprecated Replaced by access wideners for {@link class_3929#register(ScreenHandlerType, HandledScreens.Provider)}
 * and {@link class_3929.class_3930} in Fabric Transitive Access Wideners (v1).
 */
@Deprecated
public final class ScreenRegistry {
	private ScreenRegistry() {
	}

	/**
	 * Registers a new screen factory for a screen handler type.
	 *
	 * @param type          the screen handler type object
	 * @param screenFactory the screen handler factory
	 * @param <H>           the screen handler type
	 * @param <S>           the screen type
	 */
	public static <H extends class_1703, S extends class_437 & class_3936<H>> void register(class_3917<? extends H> type, Factory<H, S> screenFactory) {
		// Convert our factory to the vanilla provider here as the vanilla interface won't be available to modders.
		class_3929.method_17542(type, screenFactory::create);
	}

	/**
	 * A factory for handled screens.
	 *
	 * @param <H> the screen handler type
	 * @param <S> the screen type
	 */
	@FunctionalInterface
	public interface Factory<H extends class_1703, S extends class_437 & class_3936<H>> {
		/**
		 * Creates a new handled screen.
		 *
		 * @param handler   the screen handler
		 * @param inventory the player inventory
		 * @param title     the title of the screen
		 * @return the created screen
		 */
		S create(H handler, class_1661 inventory, class_2561 title);
	}
}
