/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class ModResourcePackUtil {
    public static final Gson GSON = new Gson();

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, class_3264 type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin") || (pack = ModNioResourcePack.create(container.getMetadata().getId(), container, subPath, type, ResourcePackActivationType.ALWAYS_ENABLED, true)) == null) continue;
            packs.add(pack);
        }
    }

    public static boolean containsDefault(String filename, boolean modBundled) {
        return "pack.mcmeta".equals(filename) || modBundled && "pack.png".equals(filename);
    }

    public static InputStream getDefaultIcon() throws IOException {
        Optional loaderIconPath = FabricLoader.getInstance().getModContainer("fabric-resource-loader-v0").flatMap(resourceLoaderContainer -> resourceLoaderContainer.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)resourceLoaderContainer).findPath(arg_0)));
        if (loaderIconPath.isPresent()) {
            return Files.newInputStream((Path)loaderIconPath.get(), new OpenOption[0]);
        }
        return null;
    }

    public static InputStream openDefault(ModContainer container, class_3264 type, String filename) throws IOException {
        switch (filename) {
            case "pack.mcmeta": {
                String description = Objects.requireNonNullElse(container.getMetadata().getName(), "");
                String metadata = ModResourcePackUtil.serializeMetadata(class_155.method_16673().method_48017(type), description);
                return IOUtils.toInputStream((String)metadata, (Charset)Charsets.UTF_8);
            }
            case "pack.png": {
                Optional path = container.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)container).findPath(arg_0));
                if (path.isPresent()) {
                    return Files.newInputStream((Path)path.get(), new OpenOption[0]);
                }
                return ModResourcePackUtil.getDefaultIcon();
            }
        }
        return null;
    }

    public static class_3272 getMetadataPack(int packVersion, class_2561 description) {
        return new class_3272(description, packVersion, Optional.empty());
    }

    public static JsonObject getMetadataPackJson(int packVersion, class_2561 description) {
        return class_3272.field_14202.method_45251((Object)ModResourcePackUtil.getMetadataPack(packVersion, description));
    }

    public static String serializeMetadata(int packVersion, String description) {
        JsonObject pack = ModResourcePackUtil.getMetadataPackJson(packVersion, (class_2561)class_2561.method_43470((String)description));
        JsonObject metadata = new JsonObject();
        metadata.add("pack", (JsonElement)pack);
        return GSON.toJson((JsonElement)metadata);
    }

    public static class_2561 getName(ModMetadata info) {
        if (info.getName() != null) {
            return class_2561.method_43470((String)info.getName());
        }
        return class_2561.method_43469((String)"pack.name.fabricMod", (Object[])new Object[]{info.getId()});
    }
}

