/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.resource.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

/**
 * Represents a resource pack provider for mods and built-in mods resource packs.
 */
public class ModResourcePackCreator implements class_3285 {
	public static final String FABRIC = "fabric";
	private static final String PROGRAMMER_ART = "programmer_art";
	private static final String HIGH_CONTRAST = "high_contrast";
	public static final class_5352 RESOURCE_PACK_SOURCE = new class_5352() {
		@Override
		public class_2561 method_45282(class_2561 packName) {
			return class_2561.method_43469("pack.nameAndSource", packName, class_2561.method_43471("pack.source.fabricmod"));
		}

		@Override
		public boolean method_45279() {
			return true;
		}
	};
	public static final ModResourcePackCreator CLIENT_RESOURCE_PACK_PROVIDER = new ModResourcePackCreator(class_3264.field_14188);
	private final class_3264 type;

	public ModResourcePackCreator(class_3264 type) {
		this.type = type;
	}

	/**
	 * Registers the resource packs.
	 *
	 * @param consumer The resource pack profile consumer.
	 */
	public void method_14453(Consumer<class_3288> consumer) {
		// This should stay as it's been used in *some* mods, it's bad I know, but it's an easy way to inject resource
		// packs, it highlights the need for an API.

		consumer.accept(class_3288.method_45275(
				FABRIC,
				class_2561.method_43471("pack.name.fabricMods"),
				true,
				new PlaceholderResourcePack.Factory(this.type),
				this.type,
				class_3288.class_3289.field_14280,
				RESOURCE_PACK_SOURCE
		));

		// Build a list of mod resource packs.
		registerModPack(consumer, null);

		if (this.type == class_3264.field_14188) {
			// Programmer Art/High Contrast data packs can never be enabled.
			registerModPack(consumer, PROGRAMMER_ART);
			registerModPack(consumer, HIGH_CONTRAST);
		}

		// Register all built-in resource packs provided by mods.
		org.quiltmc.qsl.resource.loader.impl.ResourceLoaderImpl.registerBuiltinPacks(this.type, consumer);
	}

	private void registerModPack(Consumer<class_3288> consumer, @Nullable String subPath) {
		List<ModResourcePack> packs = new ArrayList<>();
		ModResourcePackUtil.appendModResourcePacks(packs, this.type, subPath);

		for (ModResourcePack pack : packs) {
			class_2561 displayName = subPath == null
					? class_2561.method_43469("pack.name.fabricMod", pack.getFabricModMetadata().getName())
					: class_2561.method_43469("pack.name.fabricMod.subPack", pack.getFabricModMetadata().getName(), class_2561.method_43471("resourcePack." + subPath + ".name"));
			class_3288 profile = class_3288.method_45275(
					pack.method_14409(),
					displayName,
					subPath == null,
					new ModResourcePackFactory(pack),
					this.type,
					class_3288.class_3289.field_14280,
					RESOURCE_PACK_SOURCE
			);

			if (profile != null) {
				consumer.accept(profile);
			}
		}
	}
}
