/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.resource;

import net.minecraft.class_2960;
import org.quiltmc.qsl.resource.loader.api.reloader.ResourceReloaderKeys;

/**
 * This class contains default keys for various Minecraft resource reload listeners.
 *
 * @see IdentifiableResourceReloadListener
 * @deprecated Use Quilt Resource Loader API's {@link org.quiltmc.qsl.resource.loader.api.reloader.ResourceReloaderKeys} instead.
 */
@Deprecated
public final class ResourceReloadListenerKeys {
	// client
	public static final class_2960 SOUNDS = ResourceReloaderKeys.Client.SOUNDS;
	public static final class_2960 FONTS = ResourceReloaderKeys.Client.FONTS;
	public static final class_2960 MODELS = ResourceReloaderKeys.Client.MODELS;
	public static final class_2960 LANGUAGES = ResourceReloaderKeys.Client.LANGUAGES;
	public static final class_2960 TEXTURES = ResourceReloaderKeys.Client.TEXTURES;

	// server
	public static final class_2960 TAGS = ResourceReloaderKeys.Server.TAGS;
	public static final class_2960 RECIPES = ResourceReloaderKeys.Server.RECIPES;
	public static final class_2960 ADVANCEMENTS = ResourceReloaderKeys.Server.ADVANCEMENTS;
	public static final class_2960 FUNCTIONS = ResourceReloaderKeys.Server.FUNCTIONS;
	public static final class_2960 LOOT_TABLES = ResourceReloaderKeys.Server.LOOT_TABLES;

	private ResourceReloadListenerKeys() { }
}
