/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.resource;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import org.quiltmc.qsl.resource.loader.api.reloader.IdentifiableResourceReloader;

/**
 * Interface for "identifiable" resource reload listeners.
 *
 * <p>"Identifiable" listeners have a unique identifier, which can be depended on,
 * and can provide dependencies that they would like to see executed before
 * themselves.
 *
 * @see ResourceReloadListenerKeys
 * @deprecated Use Quilt Resource Loader API's {@link org.quiltmc.qsl.resource.loader.api.reloader.IdentifiableResourceReloader} instead.
 */
@Deprecated
public interface IdentifiableResourceReloadListener extends class_3302, IdentifiableResourceReloader {
	/**
	 * @return The unique identifier of this listener.
	 */
	class_2960 getFabricId();

	/**
	 * @return The identifiers of listeners this listener expects to have been
	 * executed before itself. Please keep in mind that this only takes effect
	 * during the application stage!
	 */
	default Collection<class_2960> getFabricDependencies() {
		return Collections.emptyList();
	}

	/* Quilt */

	@Override
	default class_2960 getQuiltId() {
		return this.getFabricId();
	}
}
