/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2023 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering.shader;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import net.fabricmc.fabric.impl.client.rendering.FabricShaderProgram;
import net.minecraft.class_281;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

@Mixin(class_5944.class)
abstract class ShaderProgramMixin {
	@Shadow
	@Final
	private String name;

	// Allow loading FabricShaderPrograms from arbitrary namespaces.
	@ModifyArg(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Identifier;<init>(Ljava/lang/String;)V"), allow = 1)
	private String modifyProgramId(String id) {
		if ((Object) this instanceof FabricShaderProgram) {
			return FabricShaderProgram.rewriteAsId(id, name);
		}

		return id;
	}

	// Allow loading shader stages from arbitrary namespaces.
	@ModifyVariable(method = "loadShader", at = @At("STORE"), ordinal = 1)
	private static String modifyStageId(String id, class_5912 factory, class_281.class_282 type, String name) {
		if (name.contains(String.valueOf(class_2960.field_33380))) {
			return FabricShaderProgram.rewriteAsId(id, name);
		}

		return id;
	}
}
