/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.rendering.v1;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

/**
 * Builtin item renderers render items with custom code.
 * They allow using non-model rendering, such as BERs, for items.
 *
 * <p>An item with a builtin renderer must have a model extending {@code minecraft:builtin/entity}.
 * The renderers are registered with {@link BuiltinItemRendererRegistry#register(class_1792, BuiltinItemRenderer)}.
 *
 * @deprecated Please use {@link BuiltinItemRendererRegistry.DynamicItemRenderer} instead.
 */
@Deprecated
@FunctionalInterface
public interface BuiltinItemRenderer {
	/**
	 * Renders an item stack.
	 *
	 * @param stack           the rendered item stack
	 * @param matrices        the matrix stack
	 * @param vertexConsumers the vertex consumer provider
	 * @param light           the color light multiplier at the rendering position
	 * @param overlay         the overlay UV passed to {@link net.minecraft.class_4588#method_22922(int)}
	 */
	void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay);
}
