/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_750;
import net.minecraft.class_846;
import net.minecraft.class_853;

@Environment(value=EnvType.CLIENT)
public class ChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache;
    private final Long2FloatOpenHashMap aoLevelCache;
    private final class_2338.class_2339 chunkOrigin = new class_2338.class_2339();
    class_846.class_851.class_4578.class_7435 renderData;
    class_846.class_851 chunkRenderer;
    class_750 builders;
    Set<class_1921> initializedLayers;
    class_1920 blockView;
    private final Object2ObjectOpenHashMap<class_1921, class_287> buffers = new Object2ObjectOpenHashMap();

    ChunkRenderInfo() {
        this.brightnessCache = new Long2IntOpenHashMap();
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void prepare(class_853 blockView, class_846.class_851 chunkRenderer, class_846.class_851.class_4578.class_7435 renderData, class_750 builders, Set<class_1921> initializedLayers) {
        this.blockView = blockView;
        this.chunkOrigin.method_10101((class_2382)chunkRenderer.method_3670());
        this.renderData = renderData;
        this.chunkRenderer = chunkRenderer;
        this.builders = builders;
        this.initializedLayers = initializedLayers;
        this.buffers.clear();
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
    }

    void release() {
        this.renderData = null;
        this.chunkRenderer = null;
        this.buffers.clear();
    }

    public class_287 getInitializedBuffer(class_1921 renderLayer) {
        class_287 builder = (class_287)this.buffers.get((Object)renderLayer);
        if (builder == null) {
            builder = this.builders.method_3154(renderLayer);
            if (this.initializedLayers.add(renderLayer)) {
                this.chunkRenderer.method_3655(builder);
            }
            this.buffers.put((Object)renderLayer, (Object)builder);
        }
        return builder;
    }

    int cachedBrightness(class_2338 pos, class_2680 state) {
        long key = pos.method_10063();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = AoCalculator.getLightmapCoordinates(this.blockView, state, pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(class_2338 pos, class_2680 state) {
        long key = pos.method_10063();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = AoLuminanceFix.INSTANCE.apply((class_1922)this.blockView, pos, state);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

