/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2023 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder.client;

import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_7743;
import net.minecraft.class_7744;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_7744.class)
public abstract class HangingSignEditScreenMixin extends class_7743 {
	private HangingSignEditScreenMixin(class_2625 blockEntity, boolean filtered, boolean bl) {
		super(blockEntity, filtered, bl);
	}

	@ModifyArg(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Identifier;<init>(Ljava/lang/String;)V"))
	private String init(String id) {
		if (field_40426.comp_1299().indexOf(class_2960.field_33380) != -1) {
			class_2960 identifier = new class_2960(field_40426.comp_1299());
			return identifier.method_12836() + ":textures/gui/hanging_signs/" + identifier.method_12832() + ".png";
		}

		return id;
	}
}
