/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2023 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder.client;

import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5602.class)
public class EntityModelLayersMixin {
	@Inject(method = "createSign", at = @At("HEAD"), cancellable = true)
	private static void createSign(class_4719 type, CallbackInfoReturnable<class_5601> cir) {
		if (type.comp_1299().indexOf(class_2960.field_33380) != -1) {
			class_2960 identifier = new class_2960(type.comp_1299());
			cir.setReturnValue(new class_5601(new class_2960(identifier.method_12836(), "sign/" + identifier.method_12832()), "main"));
		}
	}

	@Inject(method = "createHangingSign", at = @At("HEAD"), cancellable = true)
	private static void createHangingSign(class_4719 type, CallbackInfoReturnable<class_5601> cir) {
		if (type.comp_1299().indexOf(class_2960.field_33380) != -1) {
			class_2960 identifier = new class_2960(type.comp_1299());
			cir.setReturnValue(new class_5601(new class_2960(identifier.method_12836(), "hanging_sign/" + identifier.method_12832()), "main"));
		}
	}
}
