/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_1299;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7699;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(class_4970.class_2251.class)
public interface AbstractBlockSettingsAccessor {
	/* GETTERS */
	@Deprecated
	@Accessor
	float getHardness();

	@Deprecated
	@Accessor
	float getResistance();

	@Deprecated
	@Accessor
	boolean getCollidable();

	@Deprecated
	@Accessor
	boolean getRandomTicks();

	@Deprecated
	@Accessor("luminance")
	ToIntFunction<class_2680> getLuminance();

	@Deprecated
	@Accessor
	Function<class_2680, class_3620> getMapColorProvider();

	@Deprecated
	@Accessor
	class_2498 getSoundGroup();

	@Deprecated
	@Accessor
	float getSlipperiness();

	@Deprecated
	@Accessor
	float getVelocityMultiplier();

	@Deprecated
	@Accessor
	float getJumpVelocityMultiplier();

	@Accessor
	boolean getDynamicBounds();

	@Deprecated
	@Accessor
	boolean getOpaque();

	@Deprecated
	@Accessor
	boolean getIsAir();

	@Deprecated
	@Accessor
	boolean isToolRequired();

	@Deprecated
	@Accessor
	class_4970.class_4972<class_1299<?>> getAllowsSpawningPredicate();

	@Deprecated
	@Accessor
	class_4970.class_4973 getSolidBlockPredicate();

	@Deprecated
	@Accessor
	class_4970.class_4973 getSuffocationPredicate();

	@Deprecated
	@Accessor
	class_4970.class_4973 getBlockVisionPredicate();

	@Deprecated
	@Accessor
	class_4970.class_4973 getPostProcessPredicate();

	@Deprecated
	@Accessor
	class_4970.class_4973 getEmissiveLightingPredicate();

	@Deprecated
	@Accessor
	Optional<class_4970.class_8176> getOffsetter();

	@Deprecated
	@Accessor
	class_2960 getLootTableId();

	@Deprecated
	@Accessor
	boolean getBlockBreakParticles();

	@Deprecated
	@Accessor
	class_7699 getRequiredFeatures();

	@Accessor
	boolean getBurnable();

	@Accessor
	boolean getLiquid();

	@Accessor
	boolean getForceNotSolid();

	@Accessor
	boolean getForceSolid();

	@Accessor
	class_3619 getPistonBehavior();

	@Accessor
	class_2766 getInstrument();

	@Accessor
	boolean getReplaceable();

	/* SETTERS */
	@Accessor
	void setCollidable(boolean collidable);

	@Deprecated
	@Accessor
	void setRandomTicks(boolean ticksRandomly);

	@Accessor
	void setMapColorProvider(Function<class_2680, class_3620> mapColorProvider);

	@Accessor
	void setDynamicBounds(boolean dynamicBounds);

	@Deprecated
	@Accessor
	void setOpaque(boolean opaque);

	@Deprecated
	@Accessor
	void setIsAir(boolean isAir);

	@Accessor
	void setLootTableId(class_2960 lootTableId);

	@Deprecated
	@Accessor
	void setToolRequired(boolean toolRequired);

	@Accessor
	void setBlockBreakParticles(boolean blockBreakParticles);

	@Accessor
	void setRequiredFeatures(class_7699 requiredFeatures);

	@Accessor
	void setOffsetter(Optional<class_4970.class_8176> offsetter);

	@Accessor
	void setBurnable(boolean burnable);

	@Accessor
	void setLiquid(boolean liquid);

	@Accessor
	void setForceNotSolid(boolean forceNotSolid);

	@Accessor
	void setForceSolid(boolean forceSolid);

	@Accessor
	void setReplaceable(boolean replaceable);
}
