/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import java.util.Objects;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.Fabric2QuiltPacketSender;
import net.fabricmc.fabric.impl.networking.Quilt2FabricPacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public class QuiltUtils {
    public static <T extends class_2547> class_2596<T> createS2CPacket(FabricPacket packet, BiFunction<class_2960, class_2540, class_2596<T>> createPacketFunction) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(packet.getType(), "Packet#getType cannot return null");
        class_2540 buf = PacketByteBufs.create();
        packet.write(buf);
        return createPacketFunction.apply(packet.getType().getId(), buf);
    }

    public static <C> org.quiltmc.qsl.networking.api.PacketSender<C> toQuiltSender(PacketSender sender) {
        if (sender instanceof Quilt2FabricPacketSender) {
            Quilt2FabricPacketSender s = (Quilt2FabricPacketSender)sender;
            return s.sender;
        }
        return new Fabric2QuiltPacketSender(sender);
    }

    public static PacketSender toFabricSender(org.quiltmc.qsl.networking.api.PacketSender<?> sender) {
        if (sender instanceof Fabric2QuiltPacketSender) {
            Fabric2QuiltPacketSender s = (Fabric2QuiltPacketSender)sender;
            return s.sender;
        }
        return new Quilt2FabricPacketSender(sender);
    }
}

