/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.keybinding;

import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;

/**
 * Expanded version of {@link class_304} for use by Fabric mods.
 *
 * <p>*ALL* instantiated FabricKeyBindings should be registered in
 * {@link KeyBindingRegistry#register(FabricKeyBinding)}!</p>
 *
 * @deprecated Please migrate to v1. Please use {@link KeyBindingHelper#registerKeyBinding(KeyBinding)} instead.
 */
@Deprecated
public class FabricKeyBinding extends class_304 {
	protected FabricKeyBinding(class_2960 id, class_3675.class_307 type, int code, String category) {
		super(String.format("key.%s.%s", id.method_12836(), id.method_12832()), type, code, category);
	}

	/**
	 * Returns the configured KeyCode assigned to the KeyBinding from the player's settings.
	 *
	 * @return configured KeyCode
	 */
	@Deprecated
	public class_3675.class_306 getBoundKey() {
		return KeyBindingHelper.getBoundKeyOf(this);
	}

	@Deprecated
	public static class Builder {
		protected final FabricKeyBinding binding;

		protected Builder(FabricKeyBinding binding) {
			this.binding = binding;
		}

		public FabricKeyBinding build() {
			return binding;
		}

		public static Builder create(class_2960 id, class_3675.class_307 type, int code, String category) {
			return new Builder(new FabricKeyBinding(id, type, code, category));
		}
	}
}
