/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.itemgroup;

import net.minecraft.class_1761;
import net.minecraft.class_2561;

public final class FabricItemGroupBuilderImpl extends class_1761.class_7913 {
	private boolean hasDisplayName = false;

	public FabricItemGroupBuilderImpl() {
		// Set when building.
		super(null, -1);
	}

	@Override
	public class_1761.class_7913 method_47321(class_2561 displayName) {
		hasDisplayName = true;
		return super.method_47321(displayName);
	}

	@Override
	public class_1761 method_47324() {
		if (!hasDisplayName) {
			throw new IllegalStateException("No display name set for ItemGroup");
		}

		return super.method_47324();
	}
}
