/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.gamerule.v1;

import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_1928;

/**
 * An extended game rule visitor which supports Fabric's own rule types.
 *
 * <p>Game rule visitors are typically used iterating all game rules.
 * In vanilla, the visitor is used to register game rule commands and populate the {@code Edit Game Rules} screen.
 *
 * <p>Rule types specified by this interface are not exhaustive.
 * New entries may be added in the future.
 */
public interface FabricGameRuleVisitor extends class_1928.class_4311 {
	/**
	 * Visit a double rule.
	 *
	 * <p>Note {@link #method_20762(class_1928.class_4313, class_1928.class_4314)} will be called before this method is visited.
	 *
	 * @param key the rule key
	 * @param type the rule type
	 */
	default void visitDouble(class_1928.class_4313<DoubleRule> key, class_1928.class_4314<DoubleRule> type) {
	}

	/**
	 * Visit an enum rule.
	 *
	 * <p>Note {@link #method_20762(class_1928.class_4313, class_1928.class_4314)} will be called before this method is visited.
	 *
	 * @param key the rule key
	 * @param type the rule type
	 */
	default <E extends Enum<E>> void visitEnum(class_1928.class_4313<EnumRule<E>> key, class_1928.class_4314<EnumRule<E>> type) {
	}
}
