/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_2405;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public abstract class FabricRecipeProvider
extends class_2446 {
    protected final FabricDataOutput output;

    public FabricRecipeProvider(FabricDataOutput output) {
        super((class_7784)output);
        this.output = output;
    }

    public abstract void method_10419(class_8790 var1);

    protected class_8790 withConditions(final class_8790 exporter, final ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return new class_8790(){

            public void method_53819(class_2960 identifier, class_1860<?> recipe, @Nullable class_8779 advancementEntry) {
                FabricDataGenHelper.addConditions(recipe, conditions);
                exporter.method_53819(identifier, recipe, advancementEntry);
            }

            public class_161.class_162 method_53818() {
                return exporter.method_53818();
            }
        };
    }

    public CompletableFuture<?> method_10319(final class_7403 writer) {
        final HashSet generatedRecipes = Sets.newHashSet();
        final ArrayList list = new ArrayList();
        this.method_10419(new class_8790(){

            public void method_53819(class_2960 recipeId, class_1860<?> recipe, @Nullable class_8779 advancement) {
                class_2960 identifier = FabricRecipeProvider.this.getRecipeIdentifier(recipeId);
                if (!generatedRecipes.add(identifier)) {
                    throw new IllegalStateException("Duplicate recipe " + identifier);
                }
                JsonObject recipeJson = ((JsonElement)class_156.method_47526((DataResult)class_1860.field_47319.encodeStart((DynamicOps)JsonOps.INSTANCE, recipe), IllegalStateException::new)).getAsJsonObject();
                ConditionJsonProvider[] conditions = FabricDataGenHelper.consumeConditions(recipe);
                ConditionJsonProvider.write((JsonObject)recipeJson, (ConditionJsonProvider[])conditions);
                list.add(class_2405.method_10320((class_7403)writer, (JsonElement)recipeJson, (Path)FabricRecipeProvider.this.field_39378.method_44107(identifier)));
                if (advancement != null) {
                    JsonObject advancementJson = ((JsonElement)class_156.method_47526((DataResult)class_161.field_47179.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)advancement.comp_1920()), IllegalStateException::new)).getAsJsonObject();
                    ConditionJsonProvider.write((JsonObject)advancementJson, (ConditionJsonProvider[])conditions);
                    list.add(class_2405.method_10320((class_7403)writer, (JsonElement)advancementJson, (Path)FabricRecipeProvider.this.field_39379.method_44107(FabricRecipeProvider.this.getRecipeIdentifier(advancement.comp_1919()))));
                }
            }

            public class_161.class_162 method_53818() {
                return class_161.class_162.method_51698().method_708(class_5797.field_39377);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected class_2960 getRecipeIdentifier(class_2960 identifier) {
        return new class_2960(this.output.getModId(), identifier.method_12832());
    }
}

