/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.biome.v1;

import java.util.OptionalInt;
import net.minecraft.class_1959;
import net.minecraft.class_4763;

/**
 * Allows {@link class_1959} properties to be modified.
 *
 * @deprecated Use Quilt Biome API's {@link org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext} instead.
 */
@Deprecated
public interface BiomeModificationContext extends org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext {
	/**
	 * Returns the modification context for the biomes weather properties.
	 */
	default WeatherContext getWeather() {
		return (WeatherContext) ((org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext) this).getWeather();
	}

	/**
	 * Returns the modification context for the biomes effects.
	 */
	default EffectsContext getEffects() {
		return (EffectsContext) ((org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext) this).getEffects();
	}

	/**
	 * Returns the modification context for the biomes generation settings.
	 */
	default GenerationSettingsContext getGenerationSettings() {
		return (GenerationSettingsContext) ((org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext) this).getGenerationSettings();
	}

	/**
	 * Returns the modification context for the biomes spawn settings.
	 */
	default SpawnSettingsContext getSpawnSettings() {
		return (SpawnSettingsContext) ((org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext) this).getSpawnSettings();
	}

	interface WeatherContext extends org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext.WeatherContext {
		/**
		 * @see class_1959#method_48163()
		 * @see class_1959.class_1960#method_48164(boolean)
		 */
		default void setPrecipitation(boolean hasPrecipitation) {
			this.setHasPrecipitation(hasPrecipitation);
		}
	}

	interface EffectsContext extends org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext.EffectsContext {
		/**
		 * @see class_4763#method_30811()
		 * @see class_4763.class_4764#method_30821(int)
		 */
		default void setFoliageColor(OptionalInt color) {
			color.ifPresentOrElse(this::setFoliageColor, this::clearFoliageColor);
		}

		/**
		 * @see class_4763#method_30812()
		 * @see class_4763.class_4764#method_30822(int)
		 */
		default void setGrassColor(OptionalInt color) {
			color.ifPresentOrElse(this::setGrassColor, this::clearGrassColor);
		}
	}

	interface GenerationSettingsContext extends org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext.GenerationSettingsContext { }

	interface SpawnSettingsContext extends org.quiltmc.qsl.worldgen.biome.api.BiomeModificationContext.SpawnSettingsContext { }
}
