/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 * Copyright 2022 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.base.event;

import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2960;

public final class QuiltCompatEvent {
	private QuiltCompatEvent() {
	}

	public static <S, D> Event<D> fromQuilt(org.quiltmc.qsl.base.api.event.Event<S> event,
											Function<D, S> listenerConverter, Function<Supplier<S>, D> invoker) {
		return new QuiltEvent<>(event, listenerConverter, invoker);
	}

	public static final class QuiltEvent<S, D> extends Event<D> {
		private org.quiltmc.qsl.base.api.event.Event<S> event;
		private Function<D, S> listenerConverter;

		public QuiltEvent(org.quiltmc.qsl.base.api.event.Event<S> event, Function<D, S> listenerConverter, Function<Supplier<S>, D> invoker) {
			this.event = event;
			this.listenerConverter = listenerConverter;
			this.invoker = invoker.apply(event::invoker);
		}

		@Override
		public void register(D listener) {
			this.event.register(this.listenerConverter.apply(listener));
		}

		@Override
		public void register(class_2960 phase, D listener) {
			this.event.register(quiltifyPhases(phase), this.listenerConverter.apply(listener));
		}

		@Override
		public void addPhaseOrdering(class_2960 firstPhase, class_2960 secondPhase) {
			this.event.addPhaseOrdering(quiltifyPhases(firstPhase), quiltifyPhases(secondPhase));
		}

		// This makes Fabric's default phase equal to the Quilt one, preventing ordering issues
		private static class_2960 quiltifyPhases(class_2960 phase) {
			return phase.equals(DEFAULT_PHASE) ? org.quiltmc.qsl.base.api.event.Event.DEFAULT_PHASE : phase;
		}
	}
}
