/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public final class IOUtil {
    private IOUtil() {
    }

    public static ByteBuffer resourceToByteBuffer(String path) throws IOException {
        byte[] bytes;
        if ((path = path.trim()).startsWith("http")) {
            bytes = IOUtils.toByteArray((URL)new URL(path));
        } else {
            File file = new File(path);
            InputStream stream = file.exists() && file.isFile() ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (stream == null) {
                throw new FileNotFoundException(path);
            }
            bytes = IOUtils.toByteArray((InputStream)stream);
        }
        ByteBuffer data = ByteBuffer.allocateDirect(bytes.length).order(ByteOrder.nativeOrder()).put(bytes);
        data.flip();
        return data;
    }

    public static ByteBuffer resourceToByteBuffer(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream can not be null!");
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        ByteBuffer data = ByteBuffer.allocateDirect(bytes.length).order(ByteOrder.nativeOrder()).put(bytes);
        data.flip();
        return data;
    }

    public static ByteBuffer resourceToByteBuffer(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("File does not exist or is not a file.");
        }
        FileInputStream stream = new FileInputStream(file);
        byte[] bytes = IOUtils.toByteArray((InputStream)stream);
        ByteBuffer data = ByteBuffer.allocateDirect(bytes.length).order(ByteOrder.nativeOrder()).put(bytes);
        data.flip();
        return data;
    }

    public static String resourceToString(String path) throws IOException {
        return IOUtil.byteBufferToString(IOUtil.resourceToByteBuffer(path));
    }

    public static String resourceToString(InputStream stream) throws IOException {
        return IOUtil.byteBufferToString(IOUtil.resourceToByteBuffer(stream));
    }

    public static String resourceToString(File file) throws IOException {
        return IOUtil.byteBufferToString(IOUtil.resourceToByteBuffer(file));
    }

    public static String byteBufferToString(ByteBuffer byteBuffer) {
        return IOUtil.byteBufferToString(byteBuffer, StandardCharsets.UTF_8);
    }

    public static String byteBufferToString(ByteBuffer byteBuffer, Charset charset) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.limit() == 0) {
            return "";
        }
        byte[] buffer = new byte[byteBuffer.limit()];
        byteBuffer.get(buffer);
        return new String(buffer, charset);
    }
}

