/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.theme.colored.def;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Tooltip;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.style.border.SimpleLineBorder;
import com.spinyowl.legui.style.shadow.Shadow;
import com.spinyowl.legui.theme.AbstractTheme;
import com.spinyowl.legui.theme.Themes;
import com.spinyowl.legui.theme.colored.FlatColoredTheme;
import java.util.List;

public class FlatComponentTheme<T extends Component>
extends AbstractTheme<T> {
    protected FlatColoredTheme.FlatColoredThemeSettings settings;

    public FlatComponentTheme() {
    }

    public FlatComponentTheme(FlatColoredTheme.FlatColoredThemeSettings settings) {
        this.settings = settings;
    }

    public FlatColoredTheme.FlatColoredThemeSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FlatColoredTheme.FlatColoredThemeSettings settings) {
        this.settings = settings;
    }

    @Override
    public void apply(T component) {
        super.apply(component);
        if (this.settings.borderColor().z == 0.0f) {
            ((Component)component).getStyle().setBorder(null);
        } else {
            ((Component)component).getStyle().setBorder(new SimpleLineBorder(this.settings.borderColor(), 1.0f));
        }
        ((Component)component).getStyle().setBorderRadius(2.0f);
        ((Component)component).getStyle().getBackground().setColor(this.settings.backgroundColor());
        ((Component)component).getStyle().setFocusedStrokeColor(this.settings.strokeColor());
        ((Component)component).getStyle().setTextColor(this.settings.textColor());
        ((Component)component).getStyle().setFontSize(this.settings.fontSize());
        ((Component)component).getStyle().setFont(this.settings.font());
        ((Component)component).getStyle().setHorizontalAlign(HorizontalAlign.LEFT);
        ((Component)component).getStyle().setVerticalAlign(VerticalAlign.MIDDLE);
        if (this.settings.shadowColor() != null && this.settings.shadowColor().length() > 1.0E-5f) {
            ((Component)component).getStyle().setShadow(new Shadow(1.0f, 1.0f, 16.0f, -4.0f, this.settings.shadowColor()));
        } else {
            ((Component)component).getStyle().setShadow(null);
        }
        Tooltip tooltip = ((Component)component).getTooltip();
        if (tooltip != null) {
            Themes.getDefaultTheme().applyAll(tooltip);
        }
        List<Component> childComponents = ((Component)component).getChildComponents();
        for (Component child : childComponents) {
            Themes.getDefaultTheme().applyAll(child);
        }
    }
}

