/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.theme;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.theme.ThemeManager;

public abstract class Theme {
    private final ThemeManager themeManager;

    protected Theme(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public <T extends Component> void apply(T component) {
        this.themeManager.getComponentTheme(component.getClass()).apply(component);
    }

    public <T extends Component> void applyAll(T component) {
        this.themeManager.getComponentTheme(component.getClass()).applyAll(component);
    }

    public void applyAll(Frame frame) {
        frame.getAllLayers().forEach(this::applyAll);
    }
}

