/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.util;

import com.spinyowl.legui.system.renderer.nvg.util.NvgColorUtil;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NanoVG;

public class NvgShapes {
    public static final Vector4fc ZERO_CORNDERS = new Vector4f(0.0f);
    public static final float MIN_ALPHA = 0.001f;

    private NvgShapes() {
    }

    public static void drawRect(long nvg, Vector2fc position, Vector2fc size, Vector4fc bgColor) {
        if (bgColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor fillColor = NvgColorUtil.create(bgColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgFillColor((long)nvg, (NVGColor)fillColor);
            NanoVG.nvgRect((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y());
            NanoVG.nvgFill((long)nvg);
        }
    }

    public static void drawRect(long nvg, Vector4fc rectangle, Vector4fc bgColor) {
        if (bgColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor fillColor = NvgColorUtil.create(bgColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgFillColor((long)nvg, (NVGColor)fillColor);
            NanoVG.nvgRect((long)nvg, (float)rectangle.x(), (float)rectangle.y(), (float)rectangle.z(), (float)rectangle.w());
            NanoVG.nvgFill((long)nvg);
        }
    }

    public static void drawRect(long nvg, Vector2fc position, Vector2fc size, Vector4fc bgColor, float radius) {
        if (bgColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor fillColor = NvgColorUtil.create(bgColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgFillColor((long)nvg, (NVGColor)fillColor);
            NanoVG.nvgRoundedRect((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y(), (float)radius);
            NanoVG.nvgFill((long)nvg);
        }
    }

    public static void drawRect(long nvg, Vector2fc position, Vector2fc size, Vector4fc bgColor, Vector4f radius) {
        if (radius != null && !radius.equals((Object)ZERO_CORNDERS)) {
            try (NVGColor fillColor = NvgColorUtil.create(bgColor);){
                NanoVG.nvgBeginPath((long)nvg);
                NanoVG.nvgFillColor((long)nvg, (NVGColor)fillColor);
                if (radius.x == radius.y && radius.x == radius.z && radius.x == radius.w) {
                    NanoVG.nvgRoundedRect((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y(), (float)radius.x);
                } else {
                    NanoVG.nvgRoundedRectVarying((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y(), (float)radius.x, (float)radius.y, (float)radius.z, (float)radius.w);
                }
                NanoVG.nvgFill((long)nvg);
            }
        } else {
            NvgShapes.drawRect(nvg, position, size, bgColor);
        }
    }

    public static void drawRect(long nvg, Vector4fc rectangle, Vector4fc bgColor, float radius) {
        if (bgColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor fillColor = NvgColorUtil.create(bgColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgFillColor((long)nvg, (NVGColor)fillColor);
            NanoVG.nvgRoundedRect((long)nvg, (float)rectangle.x(), (float)rectangle.y(), (float)rectangle.z(), (float)rectangle.w(), (float)radius);
            NanoVG.nvgFill((long)nvg);
        }
    }

    public static void drawRect(long nvg, Vector4fc rectangle, Vector4fc bgColor, Vector4f radius) {
        if (radius != null && !radius.equals((Object)ZERO_CORNDERS)) {
            try (NVGColor fillColor = NvgColorUtil.create(bgColor);){
                NanoVG.nvgBeginPath((long)nvg);
                NanoVG.nvgFillColor((long)nvg, (NVGColor)fillColor);
                NanoVG.nvgRoundedRectVarying((long)nvg, (float)rectangle.x(), (float)rectangle.y(), (float)rectangle.z(), (float)rectangle.w(), (float)radius.x, (float)radius.y, (float)radius.z, (float)radius.w);
                NanoVG.nvgFill((long)nvg);
            }
        } else {
            NvgShapes.drawRect(nvg, rectangle, bgColor, radius);
        }
    }

    public static void drawRectStroke(long nvg, Vector2fc position, Vector2fc size, Vector4fc rectStrokeColor, float strokeWidth) {
        if (rectStrokeColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor strokeColor = NvgColorUtil.create(rectStrokeColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgStrokeColor((long)nvg, (NVGColor)strokeColor);
            NanoVG.nvgStrokeWidth((long)nvg, (float)strokeWidth);
            NanoVG.nvgRect((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y());
            NanoVG.nvgStroke((long)nvg);
        }
    }

    public static void drawRectStroke(long nvg, Vector4fc rectangle, Vector4fc rectStrokeColor, float strokeWidth) {
        if (rectStrokeColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor strokeColor = NvgColorUtil.create(rectStrokeColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgStrokeColor((long)nvg, (NVGColor)strokeColor);
            NanoVG.nvgStrokeWidth((long)nvg, (float)strokeWidth);
            NanoVG.nvgRect((long)nvg, (float)rectangle.x(), (float)rectangle.y(), (float)rectangle.z(), (float)rectangle.w());
            NanoVG.nvgStroke((long)nvg);
        }
    }

    public static void drawRectStroke(long nvg, Vector4fc rectangle, Vector4fc rectStrokeColor, float strokeWidth, Vector4f radius) {
        if (radius != null && !radius.equals((Object)ZERO_CORNDERS)) {
            try (NVGColor strokeColor = NvgColorUtil.create(rectStrokeColor);){
                NanoVG.nvgBeginPath((long)nvg);
                NanoVG.nvgStrokeColor((long)nvg, (NVGColor)strokeColor);
                NanoVG.nvgStrokeWidth((long)nvg, (float)strokeWidth);
                NanoVG.nvgRoundedRectVarying((long)nvg, (float)rectangle.x(), (float)rectangle.y(), (float)rectangle.z(), (float)rectangle.w(), (float)radius.x, (float)radius.y, (float)radius.z, (float)radius.w);
                NanoVG.nvgStroke((long)nvg);
            }
        } else {
            NvgShapes.drawRectStroke(nvg, rectangle, rectStrokeColor, strokeWidth);
        }
    }

    public static void drawRectStroke(long nvg, Vector2fc position, Vector2fc size, Vector4fc rectStrokeColor, float strokeWidth, float radius) {
        if (rectStrokeColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor strokeColor = NvgColorUtil.create(rectStrokeColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgStrokeColor((long)nvg, (NVGColor)strokeColor);
            NanoVG.nvgStrokeWidth((long)nvg, (float)strokeWidth);
            NanoVG.nvgRoundedRect((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y(), (float)radius);
            NanoVG.nvgStroke((long)nvg);
        }
    }

    public static void drawRectStroke(long nvg, Vector2fc position, Vector2fc size, Vector4fc rectStrokeColor, float strokeWidth, Vector4f radius) {
        if (radius != null && !radius.equals((Object)ZERO_CORNDERS)) {
            try (NVGColor strokeColor = NvgColorUtil.create(rectStrokeColor);){
                NanoVG.nvgBeginPath((long)nvg);
                NanoVG.nvgStrokeColor((long)nvg, (NVGColor)strokeColor);
                NanoVG.nvgStrokeWidth((long)nvg, (float)strokeWidth);
                NanoVG.nvgRoundedRectVarying((long)nvg, (float)position.x(), (float)position.y(), (float)size.x(), (float)size.y(), (float)radius.x, (float)radius.y, (float)radius.z, (float)radius.w);
                NanoVG.nvgStroke((long)nvg);
            }
        } else {
            NvgShapes.drawRectStroke(nvg, position, size, rectStrokeColor, strokeWidth);
        }
    }

    public static void drawRectStroke(long nvg, Vector4fc rectangle, Vector4fc rectStrokeColor, float strokeWidth, float radius) {
        if (rectStrokeColor.w() <= 0.001f) {
            return;
        }
        try (NVGColor strokeColor = NvgColorUtil.create(rectStrokeColor);){
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgStrokeColor((long)nvg, (NVGColor)strokeColor);
            NanoVG.nvgStrokeWidth((long)nvg, (float)strokeWidth);
            NanoVG.nvgRoundedRect((long)nvg, (float)rectangle.x(), (float)rectangle.y(), (float)rectangle.z(), (float)rectangle.w(), (float)radius);
            NanoVG.nvgStroke((long)nvg);
        }
    }

    public static void drawLine(long nvg, float width, Vector4f color, int lineCap, float fromX, float fromY, float toX, float toY) {
        try (NVGColor colorA = NvgColorUtil.create((Vector4fc)color);){
            NanoVG.nvgLineCap((long)nvg, (int)lineCap);
            NanoVG.nvgLineJoin((long)nvg, (int)1);
            NanoVG.nvgStrokeWidth((long)nvg, (float)width);
            NanoVG.nvgStrokeColor((long)nvg, (NVGColor)colorA);
            NanoVG.nvgBeginPath((long)nvg);
            NanoVG.nvgMoveTo((long)nvg, (float)fromX, (float)fromY);
            NanoVG.nvgLineTo((long)nvg, (float)toX, (float)toY);
            NanoVG.nvgStroke((long)nvg);
        }
    }

    public static void drawLine(long nvg, float width, Vector4f color, int lineCap, Vector2fc from, Vector2fc to) {
        NvgShapes.drawLine(nvg, width, color, lineCap, from.x(), from.y(), to.x(), to.y());
    }
}

