/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.image;

import com.spinyowl.legui.image.StbBackedLoadableImage;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgImageReferenceManager;
import com.spinyowl.legui.system.renderer.nvg.NvgImageRenderer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.joml.Vector2fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgStbBackedLoadableImageRenderer
extends NvgImageRenderer<StbBackedLoadableImage> {
    @Override
    public void initialize() {
        NvgImageReferenceManager manager = NvgImageReferenceManager.getInstance();
        manager.putImageReferenceProvider(StbBackedLoadableImage.class, (image, context) -> {
            int imageRef = 0;
            String path = image.getPath();
            if (path != null) {
                try {
                    imageRef = (Integer)manager.getImageCache().get((Object)path, this.createReference(manager, (StbBackedLoadableImage)image, (Long)context));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            } else {
                return 0;
            }
            return imageRef;
        });
    }

    private Callable<Integer> createReference(NvgImageReferenceManager manager, StbBackedLoadableImage image, Long context) {
        return () -> {
            int reference = 0;
            ByteBuffer imageData = image.getImageData();
            if (imageData != null) {
                reference = NanoVG.nvgCreateImageRGBA((long)context, (int)image.getWidth(), (int)image.getHeight(), (int)0, (ByteBuffer)imageData);
            }
            manager.getImageAssociationMap().put(image.getPath(), reference);
            return reference;
        };
    }

    @Override
    protected void renderImage(StbBackedLoadableImage image, Vector2fc position, Vector2fc size, Map<String, Object> properties, Context context, long nanovg) {
        NvgImageReferenceManager manager = NvgImageReferenceManager.getInstance();
        int imageRef = manager.getImageReference(image, nanovg);
        this.renderImage(imageRef, position, size, properties, nanovg);
    }
}

