/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.image;

import com.spinyowl.legui.image.BufferedImageRGBA;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.NvgImageReferenceManager;
import com.spinyowl.legui.system.renderer.nvg.NvgImageRenderer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.joml.Vector2fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgBufferedImageRGBARenderer
extends NvgImageRenderer<BufferedImageRGBA> {
    @Override
    public void initialize() {
        NvgImageReferenceManager manager = NvgImageReferenceManager.getInstance();
        manager.putImageReferenceProvider(BufferedImageRGBA.class, (image, context) -> {
            int imageRef = 0;
            Function<BufferedImageRGBA, String> getPath = i -> "TI::RGBA::" + i.hashCode();
            if (image != null) {
                String path = getPath.apply((BufferedImageRGBA)image);
                try {
                    imageRef = (Integer)manager.getImageCache().get((Object)path, () -> {
                        int reference = NanoVG.nvgCreateImageRGBA((long)context, (int)image.getWidth(), (int)image.getHeight(), (int)0, (ByteBuffer)image.getImageData());
                        manager.getImageAssociationMap().put((String)getPath.apply((BufferedImageRGBA)image), reference);
                        return reference;
                    });
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return imageRef;
        });
    }

    @Override
    protected void renderImage(BufferedImageRGBA image, Vector2fc position, Vector2fc size, Map<String, Object> properties, Context context, long nanovg) {
        NvgImageReferenceManager manager = NvgImageReferenceManager.getInstance();
        int imageRef = manager.getImageReference(image, nanovg);
        if (image.isUpdated()) {
            NanoVG.nvgUpdateImage((long)nanovg, (int)imageRef, (ByteBuffer)image.getImageData());
        }
        this.renderImage(imageRef, position, size, properties, nanovg);
    }
}

