/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.style.color.ColorUtil;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import com.spinyowl.legui.util.TextUtil;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgScrollBarRenderer
extends NvgDefaultComponentRenderer<ScrollBar> {
    private static final String B = TextUtil.cpToStr(58831);
    private static final String L = TextUtil.cpToStr(58827);
    private static final String R = TextUtil.cpToStr(58828);
    private static final String T = TextUtil.cpToStr(58830);

    @Override
    public void renderSelf(ScrollBar scrollBar, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, scrollBar);
        NanoVG.nvgSave((long)nanovg);
        Vector2f pos = scrollBar.getAbsolutePosition();
        Vector2f size = scrollBar.getSize();
        float arrowSize = scrollBar.getArrowSize();
        boolean arrowsEnabled = scrollBar.isArrowsEnabled();
        float diff = arrowsEnabled ? arrowSize : 0.0f;
        float offset = 1.0f;
        boolean vertical = Orientation.VERTICAL.equals(scrollBar.getOrientation());
        this.renderBackground(scrollBar, context, nanovg);
        Vector2f scrollBarPos = new Vector2f();
        Vector2f scrollBarSize = new Vector2f();
        if (vertical) {
            scrollBarPos.set(pos.x, pos.y + diff);
            scrollBarSize.set(size.x, size.y - 2.0f * diff);
        } else {
            scrollBarPos.set(pos.x + diff, pos.y);
            scrollBarSize.set(size.x - 2.0f * diff, size.y);
        }
        NvgShapes.drawRect(nanovg, (Vector2fc)scrollBarPos, (Vector2fc)scrollBarSize, (Vector4fc)scrollBar.getStyle().getBackground().getColor(), arrowsEnabled ? new Vector4f(0.0f) : NvgRenderUtils.getBorderRadius(scrollBar));
        this.drawArrows(nanovg, scrollBar, pos, size);
        this.drawScrollButton(nanovg, pos, size, scrollBar, diff, offset, vertical);
        NvgRenderUtils.resetScissor(nanovg);
    }

    private void drawArrows(long nanovg, ScrollBar scrollBar, Vector2f pos, Vector2f size) {
        boolean arrowsEnabled = scrollBar.isArrowsEnabled();
        if (arrowsEnabled) {
            String secondArrowIcon;
            String firstArrowIcon;
            Vector4f arrowColor = scrollBar.getArrowColor();
            Vector2f arrowBgSize = new Vector2f();
            Vector2f arrow2pos = new Vector2f();
            float arrowSize = scrollBar.getArrowSize();
            Vector4f cornerRadius = NvgRenderUtils.getBorderRadius(scrollBar);
            boolean vertical = Orientation.VERTICAL.equals(scrollBar.getOrientation());
            if (vertical) {
                firstArrowIcon = T;
                secondArrowIcon = B;
                arrowBgSize.set(size.x, arrowSize);
                arrow2pos.set(pos.x, pos.y + size.y - arrowSize);
            } else {
                firstArrowIcon = L;
                secondArrowIcon = R;
                arrowBgSize.set(arrowSize, size.y);
                arrow2pos.set(pos.x + size.x - arrowSize, pos.y);
            }
            NvgShapes.drawRect(nanovg, (Vector2fc)pos, (Vector2fc)arrowBgSize, (Vector4fc)arrowColor, cornerRadius);
            NvgShapes.drawRect(nanovg, (Vector2fc)arrow2pos, (Vector2fc)arrowBgSize, (Vector4fc)arrowColor, cornerRadius);
            float fontSize = vertical ? (arrowSize > arrowBgSize.x ? arrowBgSize.x : arrowSize) : (arrowSize > arrowBgSize.y ? arrowBgSize.y : arrowSize);
            Vector4f color = ColorUtil.oppositeBlackOrWhite(arrowColor);
            Vector4f firstArrowBounds = new Vector4f(pos.x, pos.y, arrowBgSize.x, arrowBgSize.y);
            Vector4f secondArrowBounds = new Vector4f(arrow2pos.x, arrow2pos.y, arrowBgSize.x, arrowBgSize.y);
            NvgText.drawTextLineToRect(nanovg, (Vector4fc)firstArrowBounds, false, HorizontalAlign.CENTER, VerticalAlign.MIDDLE, fontSize, "MaterialIcons-Regular", firstArrowIcon, color);
            NvgText.drawTextLineToRect(nanovg, (Vector4fc)secondArrowBounds, false, HorizontalAlign.CENTER, VerticalAlign.MIDDLE, fontSize, "MaterialIcons-Regular", secondArrowIcon, color);
        }
    }

    private void drawScrollButton(long nanovg, Vector2f pos, Vector2f size, ScrollBar scrollBar, float diff, float offset, boolean vertical) {
        float scrollBarSize = (vertical ? size.y : size.x) - 2.0f * diff;
        float valueRange = scrollBar.getMaxValue() - scrollBar.getMinValue();
        float barSize = scrollBarSize * scrollBar.getVisibleAmount() / valueRange;
        if (barSize < 1.0f) {
            barSize = 1.0f;
        }
        float scrollPosAccordingToScrollBounds = diff + (scrollBarSize - barSize) * scrollBar.getCurValue() / valueRange;
        Vector2f scrollPos = new Vector2f();
        Vector2f scrollSize = new Vector2f();
        if (vertical) {
            scrollPos.set(pos.x + offset, pos.y + offset + scrollPosAccordingToScrollBounds);
            scrollSize.set(size.x - 2.0f * offset, barSize - 2.0f * offset);
        } else {
            scrollPos.set(pos.x + offset + scrollPosAccordingToScrollBounds, pos.y + offset);
            scrollSize.set(barSize - 2.0f * offset, size.y - 2.0f * offset);
        }
        NvgShapes.drawRect(nanovg, (Vector2fc)scrollPos, (Vector2fc)scrollSize, (Vector4fc)scrollBar.getScrollColor(), NvgRenderUtils.getBorderRadius(scrollBar));
    }
}

