/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.PasswordInput;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorUtil;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgColorUtil;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgShapes;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGGlyphPosition;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;

public class NvgPasswordInputRenderer
extends NvgDefaultComponentRenderer<PasswordInput> {
    public static final String PRATIO = "pratio";
    public static final String PALIGN = "palign";
    public static final String POFFSET = "poffset";
    private static final int MAX_GLYPH_COUNT = 1024;
    private final Vector4f caretColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.5f);

    @Override
    public void renderSelf(PasswordInput component, Context leguiContext, long nanovg) {
        NvgRenderUtils.runWithScissor(nanovg, component, () -> {
            Vector2f pos = component.getAbsolutePosition();
            Vector2f size = component.getSize();
            boolean enabled = component.isEnabled();
            Vector4f bc = new Vector4f((Vector4fc)component.getStyle().getBackground().getColor());
            if (enabled && component.isFocused()) {
                bc.w *= 1.1f;
            } else if (!enabled) {
                bc.w *= 0.5f;
            }
            if (!component.isEditable()) {
                bc.w *= 0.3f;
            }
            this.renderBackground(component, leguiContext, nanovg);
            Vector4f padding = StyleUtilities.getPadding(component, component.getStyle());
            Vector4f intersectRect = StyleUtilities.getInnerContentRectangle(pos, size, padding);
            NvgRenderUtils.intersectScissor(nanovg, new Vector4f((Vector4fc)intersectRect).sub(1.0f, 1.0f, -2.0f, -2.0f));
            this.renderText(leguiContext, nanovg, component, size, intersectRect, bc);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderText(Context leguiContext, long context, PasswordInput gui, Vector2f size, Vector4f rect, Vector4f bc) {
        block39: {
            Vector4f textColor = StyleUtilities.getStyle(gui, Style::getTextColor);
            try (NVGGlyphPosition.Buffer glyphs = NVGGlyphPosition.calloc((int)1024);
                 NVGColor colorA = NvgColorUtil.create((Vector4fc)textColor);){
                TextState textState = gui.getTextState();
                String text = textState.getText();
                String maskedText = this.createMaskedText(gui, text);
                String font = StyleUtilities.getStyle(gui, Style::getFont, FontRegistry.getDefaultFont());
                float fontSize = StyleUtilities.getStyle(gui, Style::getFontSize, Float.valueOf(16.0f)).floatValue();
                Vector4f highlightColor = StyleUtilities.getStyle(gui, Style::getHighlightColor);
                HorizontalAlign halign = StyleUtilities.getStyle(gui, Style::getHorizontalAlign, HorizontalAlign.LEFT);
                VerticalAlign valign = StyleUtilities.getStyle(gui, Style::getVerticalAlign, VerticalAlign.MIDDLE);
                int caretPosition = gui.getCaretPosition();
                Map<String, Object> metadata = gui.getMetadata();
                int startSelectionIndex = gui.getStartSelectionIndex();
                int endSelectionIndex = gui.getEndSelectionIndex();
                boolean focused = gui.isFocused();
                NvgRenderUtils.alignTextInBox(context, halign, valign);
                NanoVG.nvgFontSize((long)context, (float)fontSize);
                NanoVG.nvgFontFace((long)context, (CharSequence)font);
                NanoVG.nvgFillColor((long)context, (NVGColor)colorA);
                int maskedLength = maskedText.length();
                if (!focused) {
                    switch (halign) {
                        case LEFT: {
                            caretPosition = 0;
                            break;
                        }
                        case RIGHT: {
                            caretPosition = maskedLength;
                            break;
                        }
                        default: {
                            caretPosition = maskedLength / 2;
                        }
                    }
                }
                if (text == null || text.isEmpty()) {
                    if (focused) {
                        this.renderCaret(context, rect, rect.x + (float)halign.index * rect.z / 2.0f);
                    }
                    gui.setMouseCaretPosition(0);
                    break block39;
                }
                float[] textBounds = NvgRenderUtils.calculateTextBoundsRect(context, rect, maskedText, halign, valign, fontSize);
                float mouseCaretX = 0.0f;
                int mouseCaretPosition = 0;
                float ratio = size.y * size.x;
                ByteBuffer textBytes = null;
                try {
                    textBytes = MemoryUtil.memUTF8((CharSequence)maskedText);
                    NvgRenderUtils.alignTextInBox(context, HorizontalAlign.LEFT, VerticalAlign.MIDDLE);
                    int ng = NanoVG.nnvgTextGlyphPositions((long)context, (float)textBounds[4], (float)0.0f, (long)MemoryUtil.memAddress((ByteBuffer)textBytes), (long)0L, (long)MemoryUtil.memAddress((CustomBuffer)glyphs), (int)1024);
                    float caretx = this.calculateCaretPos(caretPosition, textBounds, ng, glyphs);
                    float startSelectionX = this.calculateCaretPos(startSelectionIndex, textBounds, ng, glyphs);
                    float endSelectionX = this.calculateCaretPos(endSelectionIndex, textBounds, ng, glyphs);
                    float offsetX = this.getOffsetX(rect, caretx);
                    Float poffset = (Float)metadata.getOrDefault(POFFSET, Float.valueOf(offsetX));
                    Float pratio = (Float)metadata.getOrDefault(PRATIO, Float.valueOf(ratio));
                    HorizontalAlign palign = (HorizontalAlign)metadata.getOrDefault(PALIGN, halign);
                    poffset = this.recalculateOffsetX(rect, halign, caretx, ratio, offsetX, poffset, pratio, palign);
                    if (maskedLength == 0) {
                        mouseCaretX = caretx;
                    } else {
                        float mx = Mouse.getCursorPosition().x + poffset.floatValue();
                        if (mx <= ((NVGGlyphPosition)glyphs.get(0)).x()) {
                            mouseCaretX = ((NVGGlyphPosition)glyphs.get(0)).x();
                        } else if (mx >= ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx()) {
                            mouseCaretPosition = ng;
                            mouseCaretX = ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx();
                        } else if (!leguiContext.isIconified()) {
                            int upper = ng;
                            int lower = 0;
                            boolean found = false;
                            do {
                                int index;
                                float left = (index = (upper + lower) / 2) == 0 ? ((NVGGlyphPosition)glyphs.get(index)).minx() : ((NVGGlyphPosition)glyphs.get(index)).x();
                                float right = index >= ng - 1 ? ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx() : ((NVGGlyphPosition)glyphs.get(index + 1)).x();
                                float mid = (left + right) / 2.0f;
                                if (mx >= left && mx < right) {
                                    found = true;
                                    if (mx > mid) {
                                        mouseCaretPosition = index + 1;
                                        mouseCaretX = right;
                                        continue;
                                    }
                                    mouseCaretPosition = index;
                                    mouseCaretX = left;
                                    continue;
                                }
                                if (mx >= right) {
                                    if (index != ng) {
                                        lower = index + 1;
                                        continue;
                                    }
                                    found = true;
                                    mouseCaretPosition = ng;
                                    mouseCaretX = right;
                                    continue;
                                }
                                if (!(mx < left)) continue;
                                if (index != 0) {
                                    upper = index;
                                    continue;
                                }
                                found = true;
                                mouseCaretX = left;
                            } while (!found);
                        }
                    }
                    mouseCaretX -= poffset.floatValue();
                    float nCaretX = caretx - poffset.floatValue();
                    this.drawSelectionAndUpdateCaret(context, rect, bc, highlightColor, startSelectionIndex, endSelectionIndex, focused, startSelectionX, endSelectionX, poffset);
                    NvgText.drawTextLineToRect(context, (Vector4fc)new Vector4f(textBounds[4] - poffset.floatValue(), textBounds[5], textBounds[6], textBounds[7]), false, HorizontalAlign.LEFT, VerticalAlign.MIDDLE, fontSize, font, maskedText, textColor);
                    if (focused) {
                        this.renderCaret(context, rect, nCaretX);
                    }
                    if (leguiContext.isDebugEnabled()) {
                        Vector4f cc = new Vector4f((Vector4fc)this.caretColor);
                        cc.x = 1.0f;
                        this.renderCaret(context, rect, mouseCaretX);
                    }
                    this.updateMetadata(halign, metadata, ratio, poffset);
                }
                finally {
                    MemoryUtil.memFree((Buffer)textBytes);
                }
                gui.setMouseCaretPosition(mouseCaretPosition);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String createMaskedText(PasswordInput gui, String text) {
        if (gui.isMasked()) {
            StringBuilder b = new StringBuilder();
            int length = text.length();
            int maskCharacter = gui.getMaskCharacter();
            char[] mask = Character.toChars(maskCharacter);
            b.append(String.valueOf(mask).repeat(length));
            return b.toString();
        }
        return text;
    }

    private void updateMetadata(HorizontalAlign halign, Map<String, Object> metadata, float ratio, Float poffset) {
        metadata.put(POFFSET, poffset);
        metadata.put(PALIGN, halign);
        metadata.put(PRATIO, Float.valueOf(ratio));
    }

    private void drawSelectionAndUpdateCaret(long context, Vector4f rect, Vector4f bc, Vector4f highlightColor, int startSelectionIndex, int endSelectionIndex, boolean focused, float startSelectionX, float endSelectionX, Float poffset) {
        if (focused) {
            ColorUtil.oppositeBlackOrWhite(bc, this.caretColor);
            this.caretColor.w = (float)Math.abs(GLFW.glfwGetTime() % 1.0 * 2.0 - 1.0);
            if (startSelectionIndex != endSelectionIndex) {
                NvgShapes.drawRect(context, (Vector4fc)new Vector4f(startSelectionX - poffset.floatValue(), rect.y, endSelectionX - startSelectionX, rect.w), (Vector4fc)highlightColor);
            }
        }
    }

    private Float recalculateOffsetX(Vector4f rect, HorizontalAlign halign, float caretx, float ratio, float offsetX, Float poffset, Float pratio, HorizontalAlign palign) {
        float newpoffset = poffset.floatValue();
        if (pratio.floatValue() != ratio || palign != halign) {
            newpoffset = offsetX;
        } else if (caretx - poffset.floatValue() > rect.z + rect.x) {
            newpoffset = poffset.floatValue() + (caretx - poffset.floatValue() - rect.z - rect.x);
        } else if (caretx - poffset.floatValue() < rect.x) {
            newpoffset = poffset.floatValue() + (caretx - poffset.floatValue() - rect.x);
        }
        return Float.valueOf(newpoffset);
    }

    private float getOffsetX(Vector4f rect, float caretx) {
        float offsetX = 0.0f;
        if (caretx > rect.z + rect.x) {
            offsetX = caretx - rect.x - rect.z;
        } else if (caretx < rect.x) {
            offsetX = caretx - rect.x;
        }
        return offsetX;
    }

    private void renderCaret(long context, Vector4f rect, float nCaretX) {
        NvgShapes.drawLine(context, 1.0f, this.caretColor, 1, nCaretX, rect.y, nCaretX, rect.y + rect.w);
    }

    private float calculateCaretPos(int caretPosition, float[] textBounds, int ng, NVGGlyphPosition.Buffer glyphs) {
        float caretx = 0.0f;
        if (caretPosition < ng) {
            try {
                caretx = ((NVGGlyphPosition)glyphs.get(caretPosition)).x();
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        } else {
            caretx = ng > 0 ? ((NVGGlyphPosition)glyphs.get(ng - 1)).maxx() : textBounds[4];
        }
        return caretx;
    }
}

