/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.Label;
import com.spinyowl.legui.component.event.label.LabelWidthChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class NvgLabelRenderer
extends NvgDefaultComponentRenderer<Label> {
    @Override
    public void renderSelf(Label label, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, label);
        Style style = label.getStyle();
        Vector2f pos = label.getAbsolutePosition();
        Vector2f size = label.getSize();
        TextState textState = label.getTextState();
        Vector4f padding = StyleUtilities.getPadding(label, style);
        Vector4f rect = StyleUtilities.getInnerContentRectangle(pos, size, padding);
        Float fontSize = StyleUtilities.getStyle(label, Style::getFontSize, Float.valueOf(16.0f));
        VerticalAlign verticalAlign = StyleUtilities.getStyle(label, Style::getVerticalAlign, VerticalAlign.MIDDLE);
        HorizontalAlign horizontalAlign = StyleUtilities.getStyle(label, Style::getHorizontalAlign, HorizontalAlign.LEFT);
        float[] textBounds = NvgRenderUtils.calculateTextBoundsRect(nanovg, rect, textState.getText(), horizontalAlign, verticalAlign, fontSize.floatValue());
        float textWidth = textState.getTextWidth();
        if ((double)Math.abs(textWidth - textBounds[2]) > 0.001) {
            EventProcessorProvider.getInstance().pushEvent(new LabelWidthChangeEvent(label, context, label.getFrame(), textBounds[2]));
        }
        style = label.getStyle();
        pos = label.getAbsolutePosition();
        size = label.getSize();
        textState = label.getTextState();
        padding = StyleUtilities.getPadding(label, style);
        rect = StyleUtilities.getInnerContentRectangle(pos, size, padding);
        fontSize = StyleUtilities.getStyle(label, Style::getFontSize, Float.valueOf(16.0f));
        verticalAlign = StyleUtilities.getStyle(label, Style::getVerticalAlign, VerticalAlign.MIDDLE);
        horizontalAlign = StyleUtilities.getStyle(label, Style::getHorizontalAlign, HorizontalAlign.LEFT);
        textState.setTextWidth(textBounds[2]);
        textState.setTextHeight(fontSize.floatValue());
        textState.setCaretX(null);
        textState.setCaretY(null);
        this.renderBackground(label, context, nanovg);
        NvgText.drawTextLineToRect(nanovg, (Vector4fc)rect, false, horizontalAlign, verticalAlign, fontSize.floatValue(), StyleUtilities.getStyle(label, Style::getFont, FontRegistry.getDefaultFont()), textState.getText(), StyleUtilities.getStyle(label, Style::getTextColor), label.getTextDirection());
        NvgRenderUtils.resetScissor(nanovg);
    }
}

