/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg.component;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.event.button.ButtonWidthChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.component.optional.align.HorizontalAlign;
import com.spinyowl.legui.component.optional.align.VerticalAlign;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.font.FontRegistry;
import com.spinyowl.legui.style.util.StyleUtilities;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.nvg.component.NvgDefaultComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.util.NvgRenderUtils;
import com.spinyowl.legui.system.renderer.nvg.util.NvgText;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.nanovg.NanoVG;

public class NvgButtonRenderer
extends NvgDefaultComponentRenderer<Button> {
    @Override
    protected void renderSelf(Button component, Context context, long nanovg) {
        NvgRenderUtils.createScissor(nanovg, component);
        Vector2f pos = component.getAbsolutePosition();
        Vector2f size = component.getSize();
        TextState textState = component.getTextState();
        Vector4f rect = new Vector4f((Vector2fc)pos, size.x(), size.y());
        HorizontalAlign horizontalAlign = StyleUtilities.getStyle(component, Style::getHorizontalAlign, HorizontalAlign.LEFT);
        VerticalAlign verticalAlign = StyleUtilities.getStyle(component, Style::getVerticalAlign, VerticalAlign.MIDDLE);
        Float fontSize = StyleUtilities.getStyle(component, Style::getFontSize, Float.valueOf(16.0f));
        float[] textBounds = NvgRenderUtils.calculateTextBoundsRect(nanovg, rect, textState.getText(), horizontalAlign, verticalAlign, fontSize.floatValue());
        float textWidth = textState.getTextWidth();
        if ((double)Math.abs(textWidth - textBounds[2]) > 0.001) {
            EventProcessorProvider.getInstance().pushEvent(new ButtonWidthChangeEvent(component, context, component.getFrame(), textBounds[2]));
        }
        pos = component.getAbsolutePosition();
        size = component.getSize();
        NanoVG.nvgIntersectScissor((long)nanovg, (float)pos.x, (float)pos.y, (float)size.x, (float)size.y);
        textState = component.getTextState();
        rect = new Vector4f((Vector2fc)pos, size.x(), size.y());
        horizontalAlign = StyleUtilities.getStyle(component, Style::getHorizontalAlign, HorizontalAlign.LEFT);
        verticalAlign = StyleUtilities.getStyle(component, Style::getVerticalAlign, VerticalAlign.MIDDLE);
        fontSize = StyleUtilities.getStyle(component, Style::getFontSize, Float.valueOf(16.0f));
        textState.setTextWidth(textBounds[2]);
        textState.setTextHeight(fontSize.floatValue());
        textState.setCaretX(null);
        textState.setCaretY(null);
        this.renderBackground(component, context, nanovg);
        NvgText.drawTextLineToRect(nanovg, (Vector4fc)rect, true, horizontalAlign, verticalAlign, fontSize.floatValue(), StyleUtilities.getStyle(component, Style::getFont, FontRegistry.getDefaultFont()), textState.getText(), StyleUtilities.getStyle(component, Style::getTextColor), component.getTextDirection());
        NvgRenderUtils.resetScissor(nanovg);
    }
}

