/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.spinyowl.legui.image.Image;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.lwjgl.nanovg.NanoVG;

public final class NvgImageReferenceManager {
    private static final NvgImageReferenceManager INSTANCE = new NvgImageReferenceManager();
    private final Queue<String> imagesToRemove = new ConcurrentLinkedQueue<String>();
    private final RemovalListener<String, Integer> removalListener = removal -> this.imagesToRemove.add((String)removal.getKey());
    private final Cache<String, Integer> imageCache;
    private final ScheduledExecutorService cleanup = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, Integer> imageAssociationMap = new ConcurrentHashMap<String, Integer>();
    private final Map<Class<? extends Image>, BiFunction<? extends Image, Long, Integer>> imageReferenceProviders = new ConcurrentHashMap<Class<? extends Image>, BiFunction<? extends Image, Long, Integer>>();

    private NvgImageReferenceManager() {
        this.imageCache = CacheBuilder.newBuilder().initialCapacity(200).expireAfterAccess(3000L, TimeUnit.SECONDS).removalListener(this.removalListener).build();
        this.cleanup.scheduleAtFixedRate(() -> this.imageCache.cleanUp(), 1L, 1L, TimeUnit.SECONDS);
    }

    public static NvgImageReferenceManager getInstance() {
        return INSTANCE;
    }

    public <I extends Image> void putImageReferenceProvider(Class<I> imageClass, BiFunction<I, Long, Integer> imageReferenceProvider) {
        this.imageReferenceProviders.put(Objects.requireNonNull(imageClass), Objects.requireNonNull(imageReferenceProvider));
    }

    public <I extends Image> void removeImageReferenceProvider(Class<I> imageClass) {
        this.imageReferenceProviders.remove(imageClass);
    }

    public <I extends Image> BiFunction<I, Long, Integer> getImageReferenceProvider(Class<I> imageClass) {
        return this.imageReferenceProviders.get(imageClass);
    }

    protected void removeOldImages(long context) {
        String path = this.imagesToRemove.poll();
        if (path == null) {
            return;
        }
        Integer imageRef = this.imageAssociationMap.remove(path);
        if (imageRef != null) {
            NanoVG.nvgDeleteImage((long)context, (int)imageRef);
        }
    }

    public <I extends Image> int getImageReference(I image, long context) {
        Class<?> aClass;
        Integer imageRef = 0;
        if (image != null && this.imageReferenceProviders.containsKey(aClass = image.getClass())) {
            imageRef = this.getImageReferenceProvider(aClass).apply(image, context);
        }
        return imageRef;
    }

    public void destroy() {
        this.cleanup.shutdown();
    }

    public Cache<String, Integer> getImageCache() {
        return this.imageCache;
    }

    public Map<String, Integer> getImageAssociationMap() {
        return this.imageAssociationMap;
    }
}

