/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.IconRenderer;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public abstract class NvgIconRenderer<I extends Icon>
extends IconRenderer<I> {
    @Override
    public void renderIcon(I icon, Component component, Context context) {
        if (icon == null) {
            return;
        }
        long nanovgContext = (Long)context.getContextData().get("NVG_CONTEXT");
        this.renderIcon(icon, component, context, nanovgContext);
    }

    protected abstract void renderIcon(I var1, Component var2, Context var3, long var4);

    protected Vector2f calculateIconPosition(I icon, Component component, Vector2f iconSize) {
        Vector2f size = component.getSize();
        Vector2f p = new Vector2f((Vector2fc)component.getAbsolutePosition());
        if (((Icon)icon).getPosition() == null) {
            p.x += (float)((Icon)icon).getHorizontalAlign().index * (size.x - iconSize.x) / 2.0f;
            p.y += (float)((Icon)icon).getVerticalAlign().index * (size.y - iconSize.y) / 2.0f;
        } else {
            p.x += ((Icon)icon).getPosition().x;
            p.y += ((Icon)icon).getPosition().y;
        }
        return p;
    }
}

