/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.renderer.nvg;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.style.border.SimpleLineBorder;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.renderer.ComponentRenderer;
import com.spinyowl.legui.system.renderer.nvg.border.NvgSimpleLineBorderRenderer;
import com.spinyowl.legui.util.Utilites;

public abstract class NvgComponentRenderer<C extends Component>
extends ComponentRenderer<C> {
    private NvgSimpleLineBorderRenderer debugBorderRenderer = new NvgSimpleLineBorderRenderer();
    private SimpleLineBorder debugBorder = new SimpleLineBorder(ColorConstants.red(), 1.0f);
    private SimpleLineBorder debugFocusBorder = new SimpleLineBorder(ColorConstants.blue(), 2.0f);

    @Override
    public void initialize() {
        this.debugBorderRenderer.initialize();
    }

    @Override
    public void renderComponent(C component, Context context) {
        long nanovgContext = (Long)context.getContextData().get("NVG_CONTEXT");
        if (((Component)component).isVisible() && (((Component)component).keepRendering() || Utilites.visibleInParents(component))) {
            this.renderComponent(component, context, nanovgContext);
            if (context.isDebugEnabled()) {
                if (((Component)component).isFocused()) {
                    this.debugBorderRenderer.renderBorder(this.debugFocusBorder, (Component)component, context);
                } else {
                    this.debugBorderRenderer.renderBorder(this.debugBorder, (Component)component, context);
                }
            }
        } else {
            return;
        }
    }

    protected abstract void renderComponent(C var1, Context var2, long var3);
}

