/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.layout.flex;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.flex.FlexStyle;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.style.length.LengthType;
import com.spinyowl.legui.style.length.Unit;
import org.lwjgl.util.yoga.Yoga;

final class FlexUtils {
    private FlexUtils() {
    }

    public static void setJustifyContent(long node, FlexStyle.JustifyContent justifyContent, Component component) {
        FlexStyle.JustifyContent toUse = justifyContent;
        Component lp = component;
        while (toUse == FlexStyle.JustifyContent.INHERIT) {
            if (lp == null) {
                toUse = FlexStyle.JustifyContent.FLEX_START;
                break;
            }
            toUse = lp.getStyle().getFlexStyle().getJustifyContent();
            lp = lp.getParent();
        }
        if (toUse == FlexStyle.JustifyContent.INITIAL || toUse == FlexStyle.JustifyContent.FLEX_START) {
            Yoga.YGNodeStyleSetJustifyContent((long)node, (int)0);
        } else if (toUse == FlexStyle.JustifyContent.CENTER) {
            Yoga.YGNodeStyleSetJustifyContent((long)node, (int)1);
        } else if (toUse == FlexStyle.JustifyContent.FLEX_END) {
            Yoga.YGNodeStyleSetJustifyContent((long)node, (int)2);
        } else if (toUse == FlexStyle.JustifyContent.SPACE_AROUND) {
            Yoga.YGNodeStyleSetJustifyContent((long)node, (int)4);
        } else if (toUse == FlexStyle.JustifyContent.SPACE_BETWEEN) {
            Yoga.YGNodeStyleSetJustifyContent((long)node, (int)3);
        } else if (toUse == FlexStyle.JustifyContent.SPACE_EVENLY) {
            Yoga.YGNodeStyleSetJustifyContent((long)node, (int)5);
        }
    }

    public static void setFlexDirection(long rootNode, FlexStyle.FlexDirection flexDirection) {
        if (flexDirection == FlexStyle.FlexDirection.ROW) {
            Yoga.YGNodeStyleSetFlexDirection((long)rootNode, (int)2);
        } else if (flexDirection == FlexStyle.FlexDirection.COLUMN) {
            Yoga.YGNodeStyleSetFlexDirection((long)rootNode, (int)0);
        } else if (flexDirection == FlexStyle.FlexDirection.ROW_REVERSE) {
            Yoga.YGNodeStyleSetFlexDirection((long)rootNode, (int)3);
        } else if (flexDirection == FlexStyle.FlexDirection.COLUMN_REVERSE) {
            Yoga.YGNodeStyleSetFlexDirection((long)rootNode, (int)1);
        }
    }

    public static void setFlexWrap(long node, FlexStyle.FlexWrap flexWrap) {
        if (flexWrap == FlexStyle.FlexWrap.WRAP) {
            Yoga.YGNodeStyleSetFlexWrap((long)node, (int)1);
        } else if (flexWrap == FlexStyle.FlexWrap.WRAP_REVERSE) {
            Yoga.YGNodeStyleSetFlexWrap((long)node, (int)2);
        } else if (flexWrap == FlexStyle.FlexWrap.NOWRAP) {
            Yoga.YGNodeStyleSetFlexWrap((long)node, (int)0);
        }
    }

    public static void setAlignItems(long node, FlexStyle.AlignItems alignItems, Component component) {
        FlexStyle.AlignItems toUse = alignItems;
        Component lp = component;
        while (toUse == FlexStyle.AlignItems.INHERIT) {
            if (lp == null) {
                toUse = FlexStyle.AlignItems.STRETCH;
                break;
            }
            toUse = lp.getStyle().getFlexStyle().getAlignItems();
            lp = lp.getParent();
        }
        if (toUse == FlexStyle.AlignItems.FLEX_END) {
            Yoga.YGNodeStyleSetAlignItems((long)node, (int)3);
        } else if (toUse == FlexStyle.AlignItems.CENTER) {
            Yoga.YGNodeStyleSetAlignItems((long)node, (int)2);
        } else if (toUse == FlexStyle.AlignItems.FLEX_START) {
            Yoga.YGNodeStyleSetAlignItems((long)node, (int)1);
        } else if (toUse == FlexStyle.AlignItems.STRETCH) {
            Yoga.YGNodeStyleSetAlignItems((long)node, (int)4);
        } else if (toUse == FlexStyle.AlignItems.BASELINE) {
            Yoga.YGNodeStyleSetAlignItems((long)node, (int)5);
        } else if (toUse == FlexStyle.AlignItems.AUTO) {
            Yoga.YGNodeStyleSetAlignItems((long)node, (int)0);
        }
    }

    public static void setAlignSelf(long node, FlexStyle.AlignSelf alignItems, Component component) {
        FlexStyle.AlignSelf toUse = alignItems;
        Component lp = component;
        while (toUse == FlexStyle.AlignSelf.INHERIT) {
            if (lp == null) {
                toUse = FlexStyle.AlignSelf.STRETCH;
                break;
            }
            toUse = lp.getStyle().getFlexStyle().getAlignSelf();
            lp = lp.getParent();
        }
        if (toUse == FlexStyle.AlignSelf.FLEX_END) {
            Yoga.YGNodeStyleSetAlignSelf((long)node, (int)3);
        } else if (toUse == FlexStyle.AlignSelf.CENTER) {
            Yoga.YGNodeStyleSetAlignSelf((long)node, (int)2);
        } else if (toUse == FlexStyle.AlignSelf.FLEX_START) {
            Yoga.YGNodeStyleSetAlignSelf((long)node, (int)1);
        } else if (toUse == FlexStyle.AlignSelf.STRETCH) {
            Yoga.YGNodeStyleSetAlignSelf((long)node, (int)4);
        } else if (toUse == FlexStyle.AlignSelf.BASELINE) {
            Yoga.YGNodeStyleSetAlignSelf((long)node, (int)5);
        } else if (toUse == FlexStyle.AlignSelf.AUTO) {
            Yoga.YGNodeStyleSetAlignSelf((long)node, (int)0);
        }
    }

    public static void setPadding(long node, Style style) {
        Length paddingBottom;
        Length paddingRight;
        Length paddingTop;
        Length paddingLeft = style.getPaddingLeft();
        if (paddingLeft != null) {
            FlexUtils.applyPadding(node, 0, paddingLeft);
        }
        if ((paddingTop = style.getPaddingTop()) != null) {
            FlexUtils.applyPadding(node, 1, paddingTop);
        }
        if ((paddingRight = style.getPaddingRight()) != null) {
            FlexUtils.applyPadding(node, 2, paddingRight);
        }
        if ((paddingBottom = style.getPaddingBottom()) != null) {
            FlexUtils.applyPadding(node, 3, paddingBottom);
        }
    }

    public static void setMargin(long node, Style style) {
        Unit marginBottom;
        Unit marginRight;
        Unit marginTop;
        Unit marginLeft = style.getMarginLeft();
        if (marginLeft != null) {
            FlexUtils.applyMargin(node, 0, marginLeft);
        }
        if ((marginTop = style.getMarginTop()) != null) {
            FlexUtils.applyMargin(node, 1, marginTop);
        }
        if ((marginRight = style.getMarginRight()) != null) {
            FlexUtils.applyMargin(node, 2, marginRight);
        }
        if ((marginBottom = style.getMarginBottom()) != null) {
            FlexUtils.applyMargin(node, 3, marginBottom);
        }
    }

    private static void applyMargin(long node, int edge, Unit margin) {
        if (margin.isAuto()) {
            Yoga.YGNodeStyleSetMarginAuto((long)node, (int)edge);
        } else if (margin.isLength()) {
            Length m = margin.asLength();
            if (LengthType.PERCENT.equals(m.type())) {
                Yoga.YGNodeStyleSetMarginPercent((long)node, (int)edge, (float)LengthType.PERCENT.type().cast(m.get()).floatValue());
            } else if (LengthType.PIXEL.equals(m.type())) {
                Yoga.YGNodeStyleSetMargin((long)node, (int)edge, (float)LengthType.PIXEL.type().cast(m.get()).floatValue());
            }
        }
    }

    private static void applyPadding(long node, int edge, Length padding) {
        if (LengthType.PIXEL.equals(padding.type())) {
            Yoga.YGNodeStyleSetPadding((long)node, (int)edge, (float)LengthType.PIXEL.type().cast(padding.get()).floatValue());
        } else if (LengthType.PERCENT.equals(padding.type())) {
            Yoga.YGNodeStyleSetPaddingPercent((long)node, (int)edge, (float)LengthType.PERCENT.type().cast(padding.get()).floatValue());
        }
    }
}

