/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.layout.flex;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.event.component.ChangePositionEvent;
import com.spinyowl.legui.component.event.component.ChangeSizeEvent;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.flex.FlexStyle;
import com.spinyowl.legui.style.length.Length;
import com.spinyowl.legui.style.length.LengthType;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.layout.Layout;
import com.spinyowl.legui.system.layout.flex.FlexUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.lwjgl.util.yoga.Yoga;

public class FlexLayout
implements Layout {
    public static final float THRESHOLD = 1.0E-4f;

    @Override
    public void layout(Component parent) {
        this.layout(parent, null, null);
    }

    @Override
    public void layout(Component parent, Frame frame, Context context) {
        long rootNode = Yoga.YGNodeNew();
        this.prepareParentNode(parent, rootNode);
        Yoga.YGNodeStyleSetDisplay((long)rootNode, (int)0);
        ArrayList<Long> childNodes = new ArrayList<Long>();
        List components = parent.getChildComponents().stream().filter(Component::isVisible).collect(Collectors.toList());
        for (Component component : components) {
            long childNode = Yoga.YGNodeNew();
            this.prepareNode(component, childNode);
            Yoga.YGNodeInsertChild((long)rootNode, (long)childNode, (int)childNodes.size());
            childNodes.add(childNode);
        }
        Yoga.nYGNodeCalculateLayout((long)rootNode, (float)parent.getSize().x, (float)parent.getSize().y, (int)1);
        for (int i = 0; i < components.size(); ++i) {
            Component childComponent = (Component)components.get(i);
            Long yogaNode = (Long)childNodes.get(i);
            Vector2f newPos = new Vector2f(Yoga.YGNodeLayoutGetLeft((long)yogaNode), Yoga.YGNodeLayoutGetTop((long)yogaNode));
            Vector2f oldPos = childComponent.getPosition();
            childComponent.setPosition(newPos);
            Vector2f newSize = new Vector2f(Yoga.YGNodeLayoutGetWidth((long)yogaNode), Yoga.YGNodeLayoutGetHeight((long)yogaNode));
            Vector2f oldSize = childComponent.getSize();
            childComponent.setSize(newSize);
            if (frame == null || context == null) continue;
            if (!oldPos.equals((Vector2fc)newPos, 1.0E-4f)) {
                EventProcessorProvider.getInstance().pushEvent(new ChangePositionEvent<Component>(childComponent, context, frame, (Vector2fc)oldPos, (Vector2fc)newPos));
            }
            if (oldSize.equals((Vector2fc)newSize, 1.0E-4f)) continue;
            EventProcessorProvider.getInstance().pushEvent(new ChangeSizeEvent<Component>(childComponent, context, frame, (Vector2fc)oldSize, (Vector2fc)newSize));
        }
        for (Long childNode : childNodes) {
            Yoga.YGNodeFree((long)childNode);
        }
        Yoga.YGNodeFree((long)rootNode);
    }

    private void prepareParentNode(Component parent, long rootNode) {
        this.prepareNode(parent, rootNode);
        Yoga.YGNodeStyleSetWidth((long)rootNode, (float)parent.getSize().x);
        Yoga.YGNodeStyleSetHeight((long)rootNode, (float)parent.getSize().y);
    }

    private void prepareNode(Component component, long node) {
        Style style = component.getStyle();
        FlexStyle flexStyle = style.getFlexStyle();
        FlexUtils.setFlexDirection(node, flexStyle.getFlexDirection());
        FlexUtils.setJustifyContent(node, flexStyle.getJustifyContent(), component);
        FlexUtils.setAlignItems(node, flexStyle.getAlignItems(), component);
        FlexUtils.setAlignSelf(node, flexStyle.getAlignSelf(), component);
        FlexUtils.setFlexWrap(node, flexStyle.getFlexWrap());
        this.setMinWidth(node, style);
        this.setMinHeight(node, style);
        this.setMaxWidth(node, style);
        this.setMaxHeight(node, style);
        this.setWidth(node, style);
        this.setHeight(node, style);
        this.setPosition(node, style.getTop(), 1);
        this.setPosition(node, style.getBottom(), 3);
        this.setPosition(node, style.getRight(), 2);
        this.setPosition(node, style.getLeft(), 0);
        Yoga.YGNodeStyleSetFlexBasis((long)node, (float)flexStyle.getFlexBasis());
        FlexUtils.setPadding(node, style);
        FlexUtils.setMargin(node, style);
        Yoga.YGNodeStyleSetPositionType((long)node, (int)(style.getPosition() == Style.PositionType.RELATIVE ? 0 : 1));
        Yoga.YGNodeStyleSetFlexGrow((long)node, (float)flexStyle.getFlexGrow());
        Yoga.YGNodeStyleSetFlexShrink((long)node, (float)flexStyle.getFlexShrink());
    }

    private void setPosition(long node, Length distance, int edge) {
        if (distance != null) {
            if (LengthType.PIXEL.equals(distance.type())) {
                Yoga.YGNodeStyleSetPosition((long)node, (int)edge, (float)LengthType.PIXEL.type().cast(distance.get()).floatValue());
            } else if (LengthType.PERCENT.equals(distance.type())) {
                Yoga.YGNodeStyleSetPositionPercent((long)node, (int)edge, (float)LengthType.PERCENT.type().cast(distance.get()).floatValue());
            }
        }
    }

    private void setHeight(long node, Style style) {
        Length height = style.getHeight();
        if (height != null) {
            if (height.isAuto()) {
                Yoga.YGNodeStyleSetHeightAuto((long)node);
            } else {
                Length length = height.asLength();
                if (LengthType.PIXEL.equals(length.type())) {
                    Yoga.YGNodeStyleSetHeight((long)node, (float)LengthType.PIXEL.type().cast(length.get()).floatValue());
                } else if (LengthType.PERCENT.equals(length.type())) {
                    Yoga.YGNodeStyleSetHeightPercent((long)node, (float)LengthType.PERCENT.type().cast(length.get()).floatValue());
                }
            }
        }
    }

    private void setWidth(long node, Style style) {
        Length width = style.getWidth();
        if (width != null) {
            if (width.isAuto()) {
                Yoga.YGNodeStyleSetWidthAuto((long)node);
            } else {
                Length length = width.asLength();
                if (LengthType.PIXEL.equals(length.type())) {
                    Yoga.YGNodeStyleSetWidth((long)node, (float)LengthType.PIXEL.type().cast(length.get()).floatValue());
                } else if (LengthType.PERCENT.equals(length.type())) {
                    Yoga.YGNodeStyleSetWidthPercent((long)node, (float)LengthType.PERCENT.type().cast(length.get()).floatValue());
                }
            }
        }
    }

    private void setMaxHeight(long node, Style style) {
        Length maxHeight = style.getMaxHeight();
        if (maxHeight != null) {
            if (LengthType.PIXEL.equals(maxHeight.type())) {
                Yoga.YGNodeStyleSetMaxHeight((long)node, (float)LengthType.PIXEL.type().cast(maxHeight.get()).floatValue());
            } else if (LengthType.PERCENT.equals(maxHeight.type())) {
                Yoga.YGNodeStyleSetMaxHeightPercent((long)node, (float)LengthType.PERCENT.type().cast(maxHeight.get()).floatValue());
            }
        }
    }

    private void setMaxWidth(long node, Style style) {
        Length maxWidth = style.getMaxWidth();
        if (maxWidth != null) {
            if (LengthType.PIXEL.equals(maxWidth.type())) {
                Yoga.YGNodeStyleSetMaxWidth((long)node, (float)LengthType.PIXEL.type().cast(maxWidth.get()).floatValue());
            } else if (LengthType.PERCENT.equals(maxWidth.type())) {
                Yoga.YGNodeStyleSetMaxWidthPercent((long)node, (float)LengthType.PERCENT.type().cast(maxWidth.get()).floatValue());
            }
        }
    }

    private void setMinHeight(long node, Style style) {
        Length minHeight = style.getMinHeight();
        if (minHeight != null) {
            if (LengthType.PIXEL.equals(minHeight.type())) {
                Yoga.YGNodeStyleSetMinHeight((long)node, (float)LengthType.PIXEL.type().cast(minHeight.get()).floatValue());
            } else if (LengthType.PERCENT.equals(minHeight.type())) {
                Yoga.YGNodeStyleSetMinHeightPercent((long)node, (float)LengthType.PERCENT.type().cast(minHeight.get()).floatValue());
            }
        }
    }

    private void setMinWidth(long node, Style style) {
        Length minWidth = style.getMinWidth();
        if (minWidth != null) {
            if (LengthType.PIXEL.equals(minWidth.type())) {
                Yoga.YGNodeStyleSetMinWidth((long)node, (float)LengthType.PIXEL.type().cast(minWidth.get()).floatValue());
            } else if (LengthType.PERCENT.equals(minWidth.type())) {
                Yoga.YGNodeStyleSetMinWidthPercent((long)node, (float)LengthType.PERCENT.type().cast(minWidth.get()).floatValue());
            }
        }
    }
}

