/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler;

import com.spinyowl.legui.component.Component;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;

public final class SehUtil {
    private SehUtil() {
    }

    public static Component getTargetComponent(Component component, Vector2f vector) {
        Component target = component.isFocusable() ? component : null;
        List<Component> childComponents = component.getChildComponents();
        for (Component child : childComponents) {
            target = SehUtil.recursiveTargetComponentSearch(vector, child, target);
        }
        return target;
    }

    private static Component recursiveTargetComponentSearch(Vector2f vector, Component component, Component target) {
        Component newtarget = target;
        if (component.isVisible() && component.intersects(vector)) {
            if (component.isFocusable()) {
                newtarget = component;
            }
            List<Component> childComponents = component.getChildComponents();
            for (Component child : childComponents) {
                newtarget = SehUtil.recursiveTargetComponentSearch(vector, child, newtarget);
            }
        }
        return newtarget;
    }

    public static List<Component> getTargetComponentList(Component component, Vector2f vector) {
        ArrayList<Component> targetList = new ArrayList<Component>();
        SehUtil.recursiveTargetComponentListSearch(vector, component, targetList);
        return targetList;
    }

    public static void recursiveTargetComponentListSearch(Vector2f vector, Component component, List<Component> targetList) {
        if (component.isVisible() && component.intersects(vector)) {
            targetList.add(component);
            List<Component> childComponents = component.getChildComponents();
            for (Component child : childComponents) {
                SehUtil.recursiveTargetComponentListSearch(vector, child, targetList);
            }
        }
    }
}

