/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.component.Widget;
import com.spinyowl.legui.event.FocusEvent;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.event.SystemMouseClickEvent;
import com.spinyowl.legui.system.handler.SehUtil;
import com.spinyowl.legui.system.handler.SystemEventHandler;
import java.util.Collections;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class MouseClickEventHandler
implements SystemEventHandler<SystemMouseClickEvent> {
    @Override
    public void handle(SystemMouseClickEvent event, Frame frame, Context ctx) {
        Mouse.MouseButton btn = Mouse.MouseButton.getByCode(event.button);
        btn.setPressed(event.action != 0);
        Vector2f cursorPos = Mouse.getCursorPosition();
        btn.setPressPosition(cursorPos);
        List<Layer> layers = frame.getAllLayers();
        Collections.reverse(layers);
        Component focusedGui = ctx.getFocusedGui();
        Component target = null;
        for (Layer layer : layers) {
            if (layer.isEventReceivable()) {
                if (!layer.isVisible() || !layer.isEnabled()) continue;
                target = SehUtil.getTargetComponent(layer, cursorPos);
                if (target != null) break;
            }
            if (layer.isEventPassable()) continue;
            break;
        }
        int mods = event.mods;
        if (target == null) {
            if (event.action == 0) {
                if (focusedGui != null) {
                    this.updateReleasePosAndFocusedGui(btn, cursorPos, focusedGui);
                    EventProcessorProvider.getInstance().pushEvent(new MouseClickEvent<Component>(focusedGui, ctx, frame, MouseClickEvent.MouseClickAction.RELEASE, btn, this.buttonCursorPosition(cursorPos, focusedGui), cursorPos, mods));
                }
            } else {
                ctx.setFocusedGui(null);
            }
        } else {
            if (event.action == 1) {
                btn.setPressPosition(cursorPos);
                this.removeFocus(target, frame, ctx);
                target.setPressed(true);
                if (focusedGui != target) {
                    target.setFocused(true);
                    ctx.setFocusedGui(target);
                }
                EventProcessorProvider.getInstance().pushEvent(new MouseClickEvent<Component>(target, ctx, frame, MouseClickEvent.MouseClickAction.PRESS, btn, this.buttonCursorPosition(cursorPos, target), cursorPos, mods));
                if (focusedGui != target) {
                    EventProcessorProvider.getInstance().pushEvent(new FocusEvent<Component>(target, ctx, frame, target, true));
                }
            } else {
                this.updateReleasePosAndFocusedGui(btn, cursorPos, focusedGui);
                if (focusedGui != null) {
                    if (focusedGui == target) {
                        EventProcessorProvider.getInstance().pushEvent(new MouseClickEvent<Component>(target, ctx, frame, MouseClickEvent.MouseClickAction.CLICK, btn, this.buttonCursorPosition(cursorPos, target), cursorPos, mods));
                    }
                    EventProcessorProvider.getInstance().pushEvent(new MouseClickEvent<Component>(focusedGui, ctx, frame, MouseClickEvent.MouseClickAction.RELEASE, btn, this.buttonCursorPosition(cursorPos, focusedGui), cursorPos, mods));
                }
            }
            this.pushWidgetsUp(target);
        }
    }

    private Vector2f buttonCursorPosition(Vector2f cursorPos, Component target) {
        return target.getAbsolutePosition().sub((Vector2fc)cursorPos).negate();
    }

    private void updateReleasePosAndFocusedGui(Mouse.MouseButton button, Vector2f cursorPosition, Component focusedGui) {
        button.setReleasePosition(cursorPosition);
        if (focusedGui != null) {
            focusedGui.setPressed(false);
        }
    }

    private void removeFocus(Component targetComponent, Frame frame, Context context) {
        List<Layer> allLayers = frame.getAllLayers();
        for (Layer layer : allLayers) {
            List<Component> childComponents = layer.getChildComponents();
            for (Component child : childComponents) {
                this.removeFocus(targetComponent, child, context, frame);
            }
        }
    }

    private void removeFocus(Component focused, Component component, Context context, Frame frame) {
        if (component != focused && component.isVisible() && component.isFocused()) {
            component.setFocused(false);
            component.setPressed(false);
            EventProcessorProvider.getInstance().pushEvent(new FocusEvent<Component>(component, context, frame, focused, false));
        }
        List<Component> childComponents = component.getChildComponents();
        for (Component child : childComponents) {
            this.removeFocus(focused, child, context, frame);
        }
    }

    private void pushWidgetsUp(Component gui) {
        Component parent;
        Component current = gui;
        if (parent != null) {
            boolean push = false;
            for (parent = gui.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof Widget) {
                    Widget widget = (Widget)parent;
                    push = widget.isAscendible() && parent.getParent() != null && parent.getParent().getStyle().getDisplay() == Style.DisplayType.MANUAL;
                }
                current = parent;
                if (!push) continue;
            }
            if (push) {
                parent.remove(current);
                parent.add(current);
            }
        }
    }
}

