/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.event.KeyEvent;
import com.spinyowl.legui.event.KeyboardEvent;
import com.spinyowl.legui.input.KeyAction;
import com.spinyowl.legui.input.KeyMod;
import com.spinyowl.legui.input.Keyboard;
import com.spinyowl.legui.input.KeyboardKey;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.event.SystemKeyEvent;
import com.spinyowl.legui.system.handler.SystemEventHandler;
import java.util.HashSet;

public class KeyEventHandler
implements SystemEventHandler<SystemKeyEvent> {
    @Override
    public void handle(SystemKeyEvent event, Frame frame, Context context) {
        int keyCode = event.key;
        KeyboardKey key = new KeyboardKey(Keyboard.getKeyCode(event.key), event.key);
        Component focusedGui = context.getFocusedGui();
        if (focusedGui == null) {
            return;
        }
        KeyAction action = null;
        if (event.action == 0) {
            action = KeyAction.RELEASE;
        } else if (event.action == 1) {
            action = KeyAction.PRESS;
        } else if (event.action == 2) {
            action = KeyAction.REPEAT;
        }
        HashSet<KeyMod> modSet = new HashSet<KeyMod>();
        if (this.isMod(event.mods, 1)) {
            modSet.add(KeyMod.SHIFT);
        }
        if (this.isMod(event.mods, 4)) {
            modSet.add(KeyMod.ALT);
        }
        if (this.isMod(event.mods, 2)) {
            modSet.add(KeyMod.CONTROL);
        }
        if (this.isMod(event.mods, 16)) {
            modSet.add(KeyMod.CAPS_LOCK);
        }
        if (this.isMod(event.mods, 32)) {
            modSet.add(KeyMod.NUM_LOCK);
        }
        EventProcessorProvider.getInstance().pushEvent(new KeyEvent<Component>(focusedGui, context, frame, event.action, keyCode, event.mods, event.scancode));
        EventProcessorProvider.getInstance().pushEvent(new KeyboardEvent<Component>(focusedGui, context, frame, action, key, modSet));
    }

    private boolean isMod(int mods, int modToTest) {
        return (mods & modToTest) != 0;
    }
}

