/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.system.handler;

import com.spinyowl.legui.component.Frame;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.system.context.Context;
import com.spinyowl.legui.system.event.SystemEvent;
import com.spinyowl.legui.system.handler.SystemEventHandler;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSystemEventHandler<E extends SystemEvent>
implements SystemEventHandler<E> {
    @Override
    public final void handle(E event, Frame frame, Context context) {
        this.preHandle(event, frame, context);
        List<Layer> layers = frame.getAllLayers();
        Collections.reverse(layers);
        for (Layer layer : layers) {
            if (layer.isEventReceivable()) {
                if (!layer.isVisible() || !layer.isEnabled()) continue;
                if (this.handle(event, layer, context, frame)) {
                    return;
                }
            }
            if (layer.isEventPassable()) continue;
            return;
        }
        this.postHandle(event, frame, context);
    }

    protected void preHandle(E event, Frame frame, Context context) {
    }

    protected boolean handle(E event, Layer layer, Context context, Frame frame) {
        return false;
    }

    protected void postHandle(E event, Frame frame, Context context) {
    }
}

