/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.listener.processor;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.event.Event;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.listener.processor.EventProcessor;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class EventProcessorImpl
implements EventProcessor {
    private Queue<Event> first = new ConcurrentLinkedQueue<Event>();
    private Queue<Event> second = new ConcurrentLinkedQueue<Event>();
    private Consumer<Event> debugEventConsumer;

    @Override
    public void processEvents() {
        this.swap();
        Event event = this.second.poll();
        while (event != null) {
            Object targetComponent = event.getTargetComponent();
            if (targetComponent == null) {
                return;
            }
            List<EventListener<?>> listeners = ((Component)targetComponent).getListenerMap().getListeners(event.getClass());
            for (EventListener<?> listener : listeners) {
                listener.process(event);
            }
            event = this.second.poll();
        }
    }

    private void swap() {
        Queue<Event> temp = this.first;
        this.first = this.second;
        this.second = temp;
    }

    @Override
    public void pushEvent(Event event) {
        if (event.getContext() != null && event.getContext().isDebugEnabled() && this.debugEventConsumer != null) {
            this.debugEventConsumer.accept(event);
        }
        this.first.add(event);
    }

    @Override
    public boolean hasEvents() {
        return !this.first.isEmpty() || !this.second.isEmpty();
    }

    public void setDebugEventConsumer(Consumer<Event> debugEventConsumer) {
        this.debugEventConsumer = debugEventConsumer;
    }
}

