/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.listener;

import com.spinyowl.legui.event.Event;
import com.spinyowl.legui.listener.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ListenerMap {
    private final Lock lock = new ReentrantLock();
    private Map<Class<? extends Event>, List<? extends EventListener>> listenerMap = new ConcurrentHashMap<Class<? extends Event>, List<? extends EventListener>>();

    public <E extends Event> void addListener(Class<E> eventClass, EventListener<E> listener) {
        this.getListeners(eventClass).add(listener);
    }

    public <E extends Event> List<EventListener<E>> getListeners(Class<E> eventClass) {
        this.lock.lock();
        List<EventListener<E>> eventListeners = this.listenerMap.get(eventClass);
        if (eventListeners == null) {
            eventListeners = new CopyOnWriteArrayList<EventListener<E>>();
            this.listenerMap.put(eventClass, eventListeners);
        }
        this.lock.unlock();
        return eventListeners;
    }

    public <E extends Event> void removeListener(Class<E> eventClass, EventListener<E> listener) {
        this.getListeners(eventClass).remove(listener);
    }

    public <E extends Event> void removeAllListeners(Class<E> eventClass) {
        this.listenerMap.remove(eventClass);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.listenerMap).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerMap that = (ListenerMap)obj;
        return new EqualsBuilder().append(this.listenerMap, that.listenerMap).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("listenerMap", this.listenerMap).toString();
    }
}

