/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.textinput;

import com.spinyowl.legui.component.TextInput;
import com.spinyowl.legui.component.event.textinput.TextInputContentChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.event.KeyboardEvent;
import com.spinyowl.legui.input.KeyAction;
import com.spinyowl.legui.input.KeyCode;
import com.spinyowl.legui.input.KeyMod;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.util.TextUtil;
import java.util.Set;

public class TextInputKeyEventListener
implements EventListener<KeyboardEvent> {
    @Override
    public void process(KeyboardEvent event) {
        boolean pressed;
        TextInput gui = (TextInput)event.getTargetComponent();
        boolean bl = pressed = event.getAction() != KeyAction.RELEASE;
        if (!pressed) {
            return;
        }
        String oldText = gui.getTextState().getText();
        this.processKeys(event, gui);
        String newText = gui.getTextState().getText();
        if (!oldText.equals(newText)) {
            EventProcessorProvider.getInstance().pushEvent(new TextInputContentChangeEvent<TextInput>(gui, event.getContext(), event.getFrame(), oldText, newText));
        }
    }

    private void processKeys(KeyboardEvent<?> event, TextInput gui) {
        Set<KeyMod> mods = event.getMods();
        KeyCode key = event.getKey().getKeyCode();
        if (key == KeyCode.LEFT) {
            this.keyLeftAction(gui, mods);
        } else if (key == KeyCode.RIGHT) {
            this.keyRightAction(gui, mods);
        } else if (key == KeyCode.UP || key == KeyCode.HOME) {
            this.keyUpAndHomeAction(gui, mods);
        } else if (key == KeyCode.DOWN || key == KeyCode.END) {
            this.keyDownAndEndAction(gui, mods);
        } else if (key == KeyCode.BACKSPACE) {
            this.keyBackSpaceAction(gui, mods);
        } else if (key == KeyCode.DELETE) {
            this.keyDeleteAction(gui, mods);
        }
    }

    private void keyDeleteAction(TextInput gui, Set<KeyMod> mods) {
        if (gui.isEditable()) {
            int end;
            TextState textState = gui.getTextState();
            int caretPosition = gui.getCaretPosition();
            int start = gui.getStartSelectionIndex();
            if (start > (end = gui.getEndSelectionIndex())) {
                start = gui.getEndSelectionIndex();
                end = gui.getStartSelectionIndex();
            }
            if (start == end && caretPosition != textState.length()) {
                if (mods.contains((Object)KeyMod.CONTROL)) {
                    end = TextUtil.findNextWord(textState.getText(), caretPosition);
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.delete(start, end);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(start);
                    gui.setStartSelectionIndex(start);
                    gui.setEndSelectionIndex(start);
                } else {
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.deleteCharAt(caretPosition);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(caretPosition);
                    gui.setStartSelectionIndex(caretPosition);
                    gui.setEndSelectionIndex(caretPosition);
                }
            } else {
                StringBuilder builder = new StringBuilder(textState.getText());
                builder.delete(start, end);
                textState.setText(builder.toString());
                gui.setCaretPosition(start);
                gui.setStartSelectionIndex(start);
                gui.setEndSelectionIndex(start);
            }
        }
    }

    private void keyBackSpaceAction(TextInput gui, Set<KeyMod> mods) {
        if (gui.isEditable()) {
            int end;
            TextState textState = gui.getTextState();
            int caretPosition = gui.getCaretPosition();
            int start = gui.getStartSelectionIndex();
            if (start > (end = gui.getEndSelectionIndex())) {
                start = gui.getEndSelectionIndex();
                end = gui.getStartSelectionIndex();
            }
            if (start == end && caretPosition != 0) {
                if (mods.contains((Object)KeyMod.CONTROL)) {
                    start = TextUtil.findPrevWord(textState.getText(), caretPosition);
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.delete(start, end);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(start);
                    gui.setStartSelectionIndex(start);
                    gui.setEndSelectionIndex(start);
                } else {
                    int newCaretPosition = caretPosition - 1;
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.deleteCharAt(newCaretPosition);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(newCaretPosition);
                    gui.setStartSelectionIndex(newCaretPosition);
                    gui.setEndSelectionIndex(newCaretPosition);
                }
            } else {
                StringBuilder builder = new StringBuilder(textState.getText());
                builder.delete(start, end);
                textState.setText(builder.toString());
                gui.setCaretPosition(start);
                gui.setStartSelectionIndex(start);
                gui.setEndSelectionIndex(start);
            }
        }
    }

    private void keyDownAndEndAction(TextInput gui, Set<KeyMod> mods) {
        int newCaretPosition = gui.getTextState().length();
        gui.setEndSelectionIndex(newCaretPosition);
        if (!mods.contains((Object)KeyMod.SHIFT)) {
            gui.setStartSelectionIndex(newCaretPosition);
        }
        gui.setCaretPosition(newCaretPosition);
    }

    private void keyUpAndHomeAction(TextInput gui, Set<KeyMod> mods) {
        int newCaretPosition = 0;
        gui.setEndSelectionIndex(newCaretPosition);
        if (!mods.contains((Object)KeyMod.SHIFT)) {
            gui.setStartSelectionIndex(newCaretPosition);
        }
        gui.setCaretPosition(newCaretPosition);
    }

    private void keyRightAction(TextInput gui, Set<KeyMod> mods) {
        TextState textState = gui.getTextState();
        int caretPosition = gui.getCaretPosition();
        int newCaretPosition = caretPosition + 1;
        if (newCaretPosition >= textState.length()) {
            newCaretPosition = textState.length();
        }
        if (mods.contains((Object)KeyMod.CONTROL)) {
            newCaretPosition = TextUtil.findNextWord(gui.getTextState().getText(), caretPosition);
        }
        gui.setEndSelectionIndex(newCaretPosition);
        if (!mods.contains((Object)KeyMod.SHIFT)) {
            gui.setStartSelectionIndex(newCaretPosition);
        }
        gui.setCaretPosition(newCaretPosition);
    }

    private void keyLeftAction(TextInput gui, Set<KeyMod> mods) {
        int caretPosition = gui.getCaretPosition();
        int newCaretPosition = caretPosition - 1;
        if (newCaretPosition <= 0) {
            newCaretPosition = 0;
        }
        if (mods.contains((Object)KeyMod.CONTROL)) {
            newCaretPosition = TextUtil.findPrevWord(gui.getTextState().getText(), caretPosition);
        }
        gui.setEndSelectionIndex(newCaretPosition);
        if (!mods.contains((Object)KeyMod.SHIFT)) {
            gui.setStartSelectionIndex(newCaretPosition);
        }
        gui.setCaretPosition(newCaretPosition);
    }
}

