/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.textinput;

import com.spinyowl.legui.component.TextInput;
import com.spinyowl.legui.component.event.textinput.TextInputContentChangeEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.event.CharEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.CharEventListener;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.util.TextUtil;

public class TextInputCharEventListener
implements CharEventListener {
    @Override
    public void process(CharEvent event) {
        TextInput textInput = (TextInput)event.getTargetComponent();
        if (textInput.isFocused() && textInput.isEditable() && !Mouse.MouseButton.MOUSE_BUTTON_LEFT.isPressed()) {
            int end;
            String str = TextUtil.cpToStr(event.getCodepoint());
            TextState textState = textInput.getTextState();
            String oldText = textState.getText();
            int start = textInput.getStartSelectionIndex();
            if (start > (end = textInput.getEndSelectionIndex())) {
                start = textInput.getEndSelectionIndex();
                end = textInput.getStartSelectionIndex();
            }
            if (start != end) {
                StringBuilder t = new StringBuilder(textState.getText());
                t.delete(start, end);
                textState.setText(t.toString());
                textInput.setCaretPosition(start);
                textInput.setStartSelectionIndex(start);
                textInput.setEndSelectionIndex(start);
            }
            int caretPosition = textInput.getCaretPosition();
            StringBuilder t = new StringBuilder(textState.getText());
            t.insert(caretPosition, str);
            textState.setText(t.toString());
            int newCaretPosition = caretPosition + str.length();
            textInput.setCaretPosition(newCaretPosition);
            textInput.setEndSelectionIndex(newCaretPosition);
            textInput.setStartSelectionIndex(newCaretPosition);
            String newText = textState.getText();
            EventProcessorProvider.getInstance().pushEvent(new TextInputContentChangeEvent<TextInput>(textInput, event.getContext(), event.getFrame(), oldText, newText));
        }
    }
}

