/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.textarea;

import com.spinyowl.legui.component.ScrollBar;
import com.spinyowl.legui.component.TextArea;
import com.spinyowl.legui.component.TextAreaField;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldUpdateEvent;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldUpdateEventListener;
import com.spinyowl.legui.style.util.StyleUtilities;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class TextAreaFieldUpdateListener
implements TextAreaFieldUpdateEventListener {
    private final TextArea textArea;

    public TextAreaFieldUpdateListener(TextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void process(TextAreaFieldUpdateEvent event) {
        TextAreaField textAreaField = (TextAreaField)event.getTargetComponent();
        this.textArea.resizeTextAreaField();
        Vector2f absolutePosition = textAreaField.getAbsolutePosition();
        Vector4f padding = StyleUtilities.getPadding(textAreaField, textAreaField.getStyle());
        this.updateHorizontalOffset(textAreaField, absolutePosition, padding.x);
        this.updateVerticalOffset(textAreaField, absolutePosition, padding.y);
    }

    private void updateHorizontalOffset(TextAreaField textAreaField, Vector2f absolutePosition, float paddingLeft) {
        ScrollBar horizontalScrollBar = this.textArea.getHorizontalScrollBar();
        float caretX = (textAreaField.getCaretX() == null ? 0.0f : textAreaField.getCaretX().floatValue()) - absolutePosition.x - paddingLeft;
        float maxTextWidth = textAreaField.getMaxTextWidth();
        float newVal = 0.0f;
        if (maxTextWidth != 0.0f) {
            float maxValue = horizontalScrollBar.getMaxValue();
            float minValue = horizontalScrollBar.getMinValue();
            float valueRange = horizontalScrollBar.getMaxValue() - horizontalScrollBar.getMinValue();
            newVal = valueRange * caretX / maxTextWidth;
            if (newVal > maxValue) {
                newVal = maxValue;
            }
            if (newVal < minValue) {
                newVal = minValue;
            }
        }
        horizontalScrollBar.setCurValue(newVal);
    }

    private void updateVerticalOffset(TextAreaField textAreaField, Vector2f absolutePosition, float paddingTop) {
        ScrollBar verticalScrollbar = this.textArea.getVerticalScrollBar();
        float caretY = (textAreaField.getCaretY() == null ? 0.0f : textAreaField.getCaretY().floatValue()) - absolutePosition.y - paddingTop;
        float maxTextHeight = textAreaField.getMaxTextHeight();
        float newVal = 0.0f;
        float maxValue = verticalScrollbar.getMaxValue();
        float minValue = verticalScrollbar.getMinValue();
        float valueRange = verticalScrollbar.getMaxValue() - verticalScrollbar.getMinValue();
        if (maxTextHeight != textAreaField.getStyle().getFontSize().floatValue()) {
            newVal = valueRange * caretY / (maxTextHeight - textAreaField.getStyle().getFontSize().floatValue());
        }
        if (newVal > maxValue) {
            newVal = maxValue;
        }
        if (newVal < minValue) {
            newVal = minValue;
        }
        verticalScrollbar.setCurValue(newVal);
    }
}

