/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.textarea;

import com.spinyowl.legui.component.TextAreaField;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldContentChangeEvent;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldUpdateEvent;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.event.KeyboardEvent;
import com.spinyowl.legui.input.KeyAction;
import com.spinyowl.legui.input.KeyCode;
import com.spinyowl.legui.input.KeyMod;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.util.TextUtil;
import java.util.Set;

public class TextAreaFieldKeyEventListener
implements EventListener<KeyboardEvent> {
    @Override
    public void process(KeyboardEvent event) {
        KeyCode keyCode = event.getKey().getKeyCode();
        if (keyCode == KeyCode.LEFT_SHIFT || keyCode == KeyCode.RIGHT_SHIFT || keyCode == KeyCode.LEFT_CONTROL || keyCode == KeyCode.RIGHT_CONTROL || keyCode == KeyCode.LEFT_ALT || keyCode == KeyCode.RIGHT_ALT) {
            return;
        }
        TextAreaField textAreaField = (TextAreaField)event.getTargetComponent();
        boolean pressed = event.getAction() != KeyAction.RELEASE;
        String oldText = textAreaField.getTextState().getText();
        if (!pressed) {
            EventProcessorProvider.getInstance().pushEvent(new TextAreaFieldUpdateEvent(textAreaField, event.getContext(), event.getFrame()));
            return;
        }
        this.processKey(textAreaField, event);
        String newText = textAreaField.getTextState().getText();
        if (!oldText.equals(newText)) {
            EventProcessorProvider.getInstance().pushEvent(new TextAreaFieldContentChangeEvent<TextAreaField>((TextAreaField)event.getTargetComponent(), event.getContext(), event.getFrame(), oldText, newText));
        }
        EventProcessorProvider.getInstance().pushEvent(new TextAreaFieldUpdateEvent(textAreaField, event.getContext(), event.getFrame()));
    }

    private void processKey(TextAreaField textAreaField, KeyboardEvent<?> event) {
        KeyCode key = event.getKey().getKeyCode();
        Set<KeyMod> mods = event.getMods();
        if (key == KeyCode.LEFT) {
            this.keyLeftAction(textAreaField, mods);
        } else if (key == KeyCode.RIGHT) {
            this.keyRightAction(textAreaField, mods);
        } else if (key == KeyCode.UP) {
            this.keyUpAction(textAreaField, mods);
        } else if (key == KeyCode.DOWN) {
            this.keyDownAction(textAreaField, mods);
        } else if (key == KeyCode.HOME) {
            this.keyHomeAction(textAreaField, mods);
        } else if (key == KeyCode.END) {
            this.keyEndAction(textAreaField, mods);
        } else if (key == KeyCode.ENTER || key == KeyCode.NUMPAD_ENTER) {
            this.keyEnterAction(textAreaField);
        } else if (key == KeyCode.BACKSPACE) {
            this.keyBackSpaceAction(textAreaField, mods);
        } else if (key == KeyCode.DELETE) {
            this.keyDeleteAction(textAreaField, mods);
        } else if (key == KeyCode.TAB) {
            this.addTab(textAreaField, mods);
        }
    }

    private void addTab(TextAreaField textAreaField, Set<KeyMod> mods) {
        if (mods.contains((Object)KeyMod.CONTROL)) {
            return;
        }
        if (textAreaField.isEditable()) {
            int oldCPos = textAreaField.getCaretPosition();
            TextState textState = textAreaField.getTextState();
            StringBuilder t = new StringBuilder(textState.getText());
            t.insert(oldCPos, "\t");
            textState.setText(t.toString());
            int caretPosition = oldCPos + 1;
            textAreaField.setCaretPosition(caretPosition);
            textAreaField.setStartSelectionIndex(caretPosition);
            textAreaField.setEndSelectionIndex(caretPosition);
        }
    }

    private void keyDeleteAction(TextAreaField gui, Set<KeyMod> mods) {
        if (gui.isEditable()) {
            int end;
            TextState textState = gui.getTextState();
            int caretPosition = gui.getCaretPosition();
            int start = gui.getStartSelectionIndex();
            if (start > (end = gui.getEndSelectionIndex())) {
                start = gui.getEndSelectionIndex();
                end = gui.getStartSelectionIndex();
            }
            if (start == end && caretPosition != textState.length()) {
                if (mods.contains((Object)KeyMod.CONTROL)) {
                    end = TextUtil.findNextWord(textState.getText(), caretPosition);
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.delete(start, end);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(start);
                    gui.setStartSelectionIndex(start);
                    gui.setEndSelectionIndex(start);
                } else {
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.deleteCharAt(caretPosition);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(caretPosition);
                    gui.setStartSelectionIndex(caretPosition);
                    gui.setEndSelectionIndex(caretPosition);
                }
            } else {
                StringBuilder builder = new StringBuilder(textState.getText());
                builder.delete(start, end);
                textState.setText(builder.toString());
                gui.setCaretPosition(start);
                gui.setStartSelectionIndex(start);
                gui.setEndSelectionIndex(start);
            }
        }
    }

    private void keyBackSpaceAction(TextAreaField gui, Set<KeyMod> mods) {
        if (gui.isEditable()) {
            int end;
            TextState textState = gui.getTextState();
            int caretPosition = gui.getCaretPosition();
            int start = gui.getStartSelectionIndex();
            if (start > (end = gui.getEndSelectionIndex())) {
                start = gui.getEndSelectionIndex();
                end = gui.getStartSelectionIndex();
            }
            if (start == end && caretPosition != 0) {
                if (mods.contains((Object)KeyMod.CONTROL)) {
                    start = TextUtil.findPrevWord(textState.getText(), caretPosition);
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.delete(start, end);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(start);
                    gui.setStartSelectionIndex(start);
                    gui.setEndSelectionIndex(start);
                } else {
                    int newCaretPosition = caretPosition - 1;
                    StringBuilder builder = new StringBuilder(textState.getText());
                    builder.deleteCharAt(newCaretPosition);
                    textState.setText(builder.toString());
                    gui.setCaretPosition(newCaretPosition);
                    gui.setStartSelectionIndex(newCaretPosition);
                    gui.setEndSelectionIndex(newCaretPosition);
                }
            } else {
                StringBuilder builder = new StringBuilder(textState.getText());
                builder.delete(start, end);
                textState.setText(builder.toString());
                gui.setCaretPosition(start);
                gui.setStartSelectionIndex(start);
                gui.setEndSelectionIndex(start);
            }
        }
    }

    private void keyEnterAction(TextAreaField gui) {
        if (gui.isEditable()) {
            int start = gui.getStartSelectionIndex();
            int end = gui.getEndSelectionIndex();
            TextState textState = gui.getTextState();
            StringBuilder builder = new StringBuilder(textState.getText());
            int caretPosition = gui.getCaretPosition();
            if (start != end) {
                if (start > end) {
                    start = gui.getEndSelectionIndex();
                    end = gui.getStartSelectionIndex();
                }
                builder.delete(start, end);
                textState.setText(builder.toString());
                caretPosition = start;
            }
            builder.insert(caretPosition, "\n");
            textState.setText(builder.toString());
            int newCaretPosition = caretPosition + 1;
            gui.setStartSelectionIndex(newCaretPosition);
            gui.setEndSelectionIndex(newCaretPosition);
            gui.setCaretPosition(newCaretPosition);
        }
    }

    private void keyEndAction(TextAreaField gui, Set<KeyMod> mods) {
        TextState textState = gui.getTextState();
        int caretPosition = gui.getCaretPosition();
        String text = textState.getText();
        String[] lines = text.split("\n", -1);
        LineData currentLine = this.getStartLineIndexAndLineNumber(lines, caretPosition);
        int cl = lines[currentLine.lineIndex].length();
        int delta = cl - currentLine.caretPositionInLine;
        int newCaretPosition = mods.contains((Object)KeyMod.CONTROL) ? text.length() : caretPosition + delta;
        this.updateIndices(gui, mods, newCaretPosition);
    }

    private void keyHomeAction(TextAreaField gui, Set<KeyMod> mods) {
        TextState textState = gui.getTextState();
        int caretPosition = gui.getCaretPosition();
        String text = textState.getText();
        String[] lines = text.split("\n", -1);
        LineData some = this.getStartLineIndexAndLineNumber(lines, caretPosition);
        int newCaretPosition = mods.contains((Object)KeyMod.CONTROL) ? 0 : caretPosition - some.caretPositionInLine;
        this.updateIndices(gui, mods, newCaretPosition);
    }

    private void keyDownAction(TextAreaField gui, Set<KeyMod> mods) {
        TextState textState = gui.getTextState();
        int caretPosition = gui.getCaretPosition();
        if (caretPosition < textState.length()) {
            int newCaretPosition;
            String text = textState.getText();
            String[] lines = text.split("\n", -1);
            LineData some = this.getStartLineIndexAndLineNumber(lines, caretPosition);
            if (some.lineIndex < lines.length - 1) {
                int nl = lines[some.lineIndex + 1].length() + 1;
                int cl = lines[some.lineIndex].length() + 1;
                newCaretPosition = some.caretPositionInLine >= nl - 1 ? caretPosition + nl + cl - 1 - some.caretPositionInLine : caretPosition + cl;
            } else {
                newCaretPosition = text.length();
            }
            this.updateIndices(gui, mods, newCaretPosition);
        }
    }

    private void keyUpAction(TextAreaField gui, Set<KeyMod> mods) {
        int caretPosition = gui.getCaretPosition();
        if (caretPosition > 0) {
            int nl;
            TextState textState = gui.getTextState();
            String text = textState.getText();
            String[] lines = text.split("\n", -1);
            LineData some = this.getStartLineIndexAndLineNumber(lines, caretPosition);
            int newCaretPosition = some.lineIndex > 0 ? caretPosition - (some.caretPositionInLine >= (nl = lines[some.lineIndex - 1].length() + 1) - 1 ? some.caretPositionInLine + 1 : nl) : 0;
            this.updateIndices(gui, mods, newCaretPosition);
        }
    }

    private void keyRightAction(TextAreaField gui, Set<KeyMod> mods) {
        int newCaretPosition;
        TextState textState = gui.getTextState();
        int caretPosition = gui.getCaretPosition();
        if (mods.contains((Object)KeyMod.CONTROL)) {
            newCaretPosition = TextUtil.findNextWord(gui.getTextState().getText(), caretPosition);
        } else {
            newCaretPosition = caretPosition + 1;
            if (newCaretPosition >= textState.length()) {
                newCaretPosition = textState.length();
            }
        }
        this.updateIndices(gui, mods, newCaretPosition);
    }

    private void keyLeftAction(TextAreaField gui, Set<KeyMod> mods) {
        int newCaretPosition;
        int caretPosition = gui.getCaretPosition();
        if (mods.contains((Object)KeyMod.CONTROL)) {
            newCaretPosition = TextUtil.findPrevWord(gui.getTextState().getText(), caretPosition);
        } else {
            newCaretPosition = caretPosition - 1;
            if (newCaretPosition <= 0) {
                newCaretPosition = 0;
            }
        }
        this.updateIndices(gui, mods, newCaretPosition);
    }

    private void updateIndices(TextAreaField gui, Set<KeyMod> mods, int newCaretPosition) {
        if (!mods.contains((Object)KeyMod.SHIFT)) {
            gui.setStartSelectionIndex(newCaretPosition);
        }
        gui.setEndSelectionIndex(newCaretPosition);
        gui.setCaretPosition(newCaretPosition);
    }

    private LineData getStartLineIndexAndLineNumber(String[] lines, int caretPosition) {
        String line;
        int newOffset;
        int caretLine = 0;
        int caretOffset = 0;
        String[] stringArray = lines;
        int n = stringArray.length;
        for (int i = 0; i < n && (newOffset = caretOffset + (line = stringArray[i]).length()) < caretPosition; ++i) {
            ++caretLine;
            caretOffset = newOffset + 1;
        }
        return new LineData(caretPosition - caretOffset, caretLine);
    }

    private static class LineData {
        private final int caretPositionInLine;
        private final int lineIndex;

        private LineData(int caretPositionInLine, int lineIndex) {
            this.caretPositionInLine = caretPositionInLine;
            this.lineIndex = lineIndex;
        }
    }
}

