/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.listener.splitpanel;

import com.spinyowl.legui.component.SplitPanel;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.input.Mouse;
import com.spinyowl.legui.listener.MouseDragEventListener;
import org.joml.Vector2f;

public class SplitPanelDragListener
implements MouseDragEventListener {
    private final SplitPanel splitPanel;

    public SplitPanelDragListener(SplitPanel splitPanel) {
        this.splitPanel = splitPanel;
    }

    @Override
    public void process(MouseDragEvent event) {
        float d;
        Orientation orientation = this.splitPanel.getOrientation();
        float ratio = this.splitPanel.getRatio();
        Vector2f delta = event.getDelta();
        if (orientation == Orientation.HORIZONTAL) {
            d = delta.x;
            if (d > 0.0f && this.splitPanel.getPosition().x > Mouse.getCursorPosition().x) {
                return;
            }
            if (d < 0.0f && this.splitPanel.getPosition().x + this.splitPanel.getSize().x < Mouse.getCursorPosition().x) {
                return;
            }
        } else {
            d = delta.y;
            if (d > 0.0f && this.splitPanel.getPosition().y > Mouse.getCursorPosition().y) {
                return;
            }
            if (d < 0.0f && this.splitPanel.getPosition().y + this.splitPanel.getSize().y < Mouse.getCursorPosition().y) {
                return;
            }
        }
        this.updateGrow(ratio += 100.0f * d / this.getActualSpace(orientation), orientation);
        this.splitPanel.setRatio(ratio);
    }

    private int getLeftGrow(float ratio, Orientation orientation) {
        return (int)(ratio * this.getActualSpace(orientation) / 100.0f);
    }

    private int getRightGrow(float ratio, Orientation orientation) {
        return (int)((100.0f - ratio) * this.getActualSpace(orientation) / 100.0f);
    }

    private void updateGrow(float ratio, Orientation orientation) {
        this.splitPanel.getTopLeft().getStyle().getFlexStyle().setFlexGrow(this.getLeftGrow(ratio, orientation));
        this.splitPanel.getBottomRight().getStyle().getFlexStyle().setFlexGrow(this.getRightGrow(ratio, orientation));
    }

    private float getActualSpace(Orientation orientation) {
        float actual = Orientation.HORIZONTAL == orientation ? this.splitPanel.getSize().x - this.splitPanel.getSeparatorThickness() : this.splitPanel.getSize().y - this.splitPanel.getSeparatorThickness();
        return actual;
    }
}

