/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component.misc.animation.selectbox;

import com.spinyowl.legui.animation.Animation;
import com.spinyowl.legui.component.SelectBox;
import java.lang.ref.WeakReference;
import org.joml.Vector2f;

public class SelectBoxAnimation
extends Animation {
    private final WeakReference<SelectBox> selectBox;
    private final WeakReference<SelectBox.SelectBoxScrollablePanel> selectionListPanel;
    private double deltaSum = 0.0;

    public SelectBoxAnimation(SelectBox selectBox, SelectBox.SelectBoxScrollablePanel selectionListPanel) {
        this.selectBox = new WeakReference<SelectBox>(selectBox);
        this.selectionListPanel = new WeakReference<SelectBox.SelectBoxScrollablePanel>(selectionListPanel);
    }

    @Override
    protected boolean animate(double delta) {
        SelectBox selectBox = (SelectBox)this.selectBox.get();
        SelectBox.SelectBoxScrollablePanel selectionListPanel = (SelectBox.SelectBoxScrollablePanel)this.selectionListPanel.get();
        if (selectBox == null || selectionListPanel == null) {
            return true;
        }
        if (selectBox.isCollapsed()) {
            return false;
        }
        this.deltaSum += delta;
        if (this.deltaSum < 0.01) {
            return false;
        }
        float buttonWidth = selectBox.getButtonWidth();
        selectionListPanel.getVerticalScrollBar().getStyle().setMaxWidth(buttonWidth);
        selectionListPanel.getVerticalScrollBar().getStyle().setMaxWidth(buttonWidth);
        int visibleCount = Math.min(selectBox.getVisibleCount(), selectBox.getElements().size());
        float elementHeight = selectBox.getElementHeight();
        Vector2f size = selectBox.getSize();
        Vector2f wsize = new Vector2f(size.x, (float)visibleCount * elementHeight);
        Vector2f wpos = new Vector2f();
        Vector2f sbPos = selectBox.getAbsolutePosition();
        Vector2f pSize = selectBox.getSelectBoxLayer().getSize();
        if (sbPos.y + wsize.y + size.y > pSize.y && sbPos.y - wsize.y > 0.0f) {
            wpos.set(sbPos.x, sbPos.y - wsize.y);
        } else {
            wpos.set(sbPos.x, sbPos.y + size.y);
        }
        selectionListPanel.setSize(wsize);
        selectionListPanel.setPosition(wpos);
        selectionListPanel.getContainer().getSize().y = (float)selectionListPanel.getContainer().count() * elementHeight;
        selectionListPanel.getContainer().getSize().x = size.x - selectionListPanel.getVerticalScrollBar().getSize().x;
        this.deltaSum = 0.0;
        return false;
    }
}

