/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class Tooltip
extends AbstractTextComponent {
    private Component component;

    public Tooltip() {
        this.initialize("");
    }

    public Tooltip(String tooltip) {
        this.initialize(tooltip);
    }

    private void initialize(String text) {
        this.textState = new TextState(text);
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Tooltip.class).applyAll(this);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        if (component == this) {
            return;
        }
        if (this.component == component) {
            return;
        }
        if (this.component != null) {
            Component prev = this.component;
            this.component = null;
            prev.setTooltip(null);
        }
        this.component = component;
        if (component != null) {
            component.setTooltip(this);
        }
    }

    @Override
    public Vector2f getAbsolutePosition() {
        Vector2f position = new Vector2f((Vector2fc)this.getPosition());
        if (this.component != null) {
            position.add((Vector2fc)this.component.getAbsolutePosition());
        }
        return position;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tooltip tooltip = (Tooltip)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.textState, (Object)tooltip.textState).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).toString();
    }
}

