/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.event.textinput.TextInputContentChangeEvent;
import com.spinyowl.legui.component.misc.listener.text.CopyTextEventListener;
import com.spinyowl.legui.component.misc.listener.text.SelectAllTextEventListener;
import com.spinyowl.legui.component.misc.listener.textinput.CutTextInputKeyboardEventListener;
import com.spinyowl.legui.component.misc.listener.textinput.PasteTextInputKeyboardEventListener;
import com.spinyowl.legui.component.misc.listener.textinput.TextInputCharEventListener;
import com.spinyowl.legui.component.misc.listener.textinput.TextInputDragEventListener;
import com.spinyowl.legui.component.misc.listener.textinput.TextInputKeyEventListener;
import com.spinyowl.legui.component.misc.listener.textinput.TextInputMouseClickEventListener;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.event.CharEvent;
import com.spinyowl.legui.event.KeyboardEvent;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.theme.Themes;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class TextInput
extends AbstractTextComponent {
    public TextInput() {
        this.initialize("");
    }

    public TextInput(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize("");
    }

    public TextInput(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize("");
    }

    public TextInput(String text) {
        this.initialize(text);
    }

    public TextInput(String text, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(text);
    }

    public TextInput(String text, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(text);
    }

    private void initialize(String text) {
        this.textState = new TextState(text);
        this.getStyle().setPadding(1.0f, 5.0f);
        this.getListenerMap().addListener(KeyboardEvent.class, new TextInputKeyEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new SelectAllTextEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new CopyTextEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new PasteTextInputKeyboardEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new CutTextInputKeyboardEventListener());
        this.getListenerMap().addListener(MouseClickEvent.class, new TextInputMouseClickEventListener());
        this.getListenerMap().addListener(MouseDragEvent.class, new TextInputDragEventListener());
        this.getListenerMap().addListener(CharEvent.class, new TextInputCharEventListener());
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(TextInput.class).applyAll(this);
    }

    public int getMouseCaretPosition() {
        return this.textState.getMouseCaretPosition();
    }

    public void setMouseCaretPosition(int mouseCaretPosition) {
        this.textState.setMouseCaretPosition(mouseCaretPosition);
    }

    public boolean isEditable() {
        return this.textState.isEditable();
    }

    public void setEditable(boolean editable) {
        this.textState.setEditable(editable);
    }

    public int getCaretPosition() {
        return this.textState.getCaretPosition();
    }

    public void setCaretPosition(int caretPosition) {
        this.textState.setCaretPosition(caretPosition);
    }

    public int getStartSelectionIndex() {
        return this.textState.getStartSelectionIndex();
    }

    public void setStartSelectionIndex(int startSelectionIndex) {
        this.textState.setStartSelectionIndex(startSelectionIndex);
    }

    public int getEndSelectionIndex() {
        return this.textState.getEndSelectionIndex();
    }

    public void setEndSelectionIndex(int endSelectionIndex) {
        this.textState.setEndSelectionIndex(endSelectionIndex);
    }

    public String getSelection() {
        return this.textState.getSelection();
    }

    public void addTextInputContentChangeEventListener(EventListener<TextInputContentChangeEvent> eventListener) {
        this.getListenerMap().addListener(TextInputContentChangeEvent.class, eventListener);
    }

    public List<EventListener<TextInputContentChangeEvent>> getTextInputContentChangeEvents() {
        return this.getListenerMap().getListeners(TextInputContentChangeEvent.class);
    }

    public void removeTextInputContentChangeEventListener(EventListener<TextInputContentChangeEvent> eventListener) {
        this.getListenerMap().removeListener(TextInputContentChangeEvent.class, eventListener);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextInput input = (TextInput)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.textState, (Object)input.textState).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).toHashCode();
    }
}

