/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.AbstractTextComponent;
import com.spinyowl.legui.component.event.textarea.TextAreaFieldUpdateEvent;
import com.spinyowl.legui.component.misc.listener.text.CopyTextEventListener;
import com.spinyowl.legui.component.misc.listener.text.SelectAllTextEventListener;
import com.spinyowl.legui.component.misc.listener.textarea.CutTextAreaKeyboardEventListener;
import com.spinyowl.legui.component.misc.listener.textarea.PasteTextAreaKeyboardEventListener;
import com.spinyowl.legui.component.misc.listener.textarea.TextAreaFieldCharEventListener;
import com.spinyowl.legui.component.misc.listener.textarea.TextAreaFieldDragEventListener;
import com.spinyowl.legui.component.misc.listener.textarea.TextAreaFieldKeyEventListener;
import com.spinyowl.legui.component.misc.listener.textarea.TextAreaFieldMouseClickEventListener;
import com.spinyowl.legui.component.optional.TextState;
import com.spinyowl.legui.event.CharEvent;
import com.spinyowl.legui.event.KeyboardEvent;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.listener.processor.EventProcessorProvider;
import com.spinyowl.legui.theme.Themes;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;

public class TextAreaField
extends AbstractTextComponent {
    private int tabSize = 4;
    private boolean stickToAlignment = true;

    public TextAreaField() {
        this.initialize("");
    }

    public TextAreaField(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize("");
    }

    public TextAreaField(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize("");
    }

    public TextAreaField(String text) {
        this.initialize(text);
    }

    public TextAreaField(String text, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize(text);
    }

    public TextAreaField(String text, Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize(text);
    }

    private void initialize(String s) {
        this.textState = new TextState(s, (prev, next) -> EventProcessorProvider.getInstance().pushEvent(new TextAreaFieldUpdateEvent(this, null, this.getFrame())));
        this.getStyle().setPadding(10.0f, 5.0f);
        this.getListenerMap().addListener(MouseDragEvent.class, new TextAreaFieldDragEventListener());
        this.getListenerMap().addListener(MouseClickEvent.class, new TextAreaFieldMouseClickEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new CutTextAreaKeyboardEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new PasteTextAreaKeyboardEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new SelectAllTextEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new CopyTextEventListener());
        this.getListenerMap().addListener(KeyboardEvent.class, new TextAreaFieldKeyEventListener());
        this.getListenerMap().addListener(CharEvent.class, new TextAreaFieldCharEventListener());
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(TextAreaField.class).applyAll(this);
    }

    public int getCaretPosition() {
        return this.textState.getCaretPosition();
    }

    public void setCaretPosition(int caretPosition) {
        this.textState.setCaretPosition(caretPosition);
    }

    public boolean isEditable() {
        return this.textState.isEditable();
    }

    public void setEditable(boolean editable) {
        this.textState.setEditable(editable);
    }

    public int getMouseCaretPosition() {
        return this.textState.getMouseCaretPosition();
    }

    public void setMouseCaretPosition(int mouseCaretPosition) {
        this.textState.setMouseCaretPosition(mouseCaretPosition);
    }

    public int getStartSelectionIndex() {
        return this.textState.getStartSelectionIndex();
    }

    public void setStartSelectionIndex(int startSelectionIndex) {
        this.textState.setStartSelectionIndex(startSelectionIndex);
    }

    public int getEndSelectionIndex() {
        return this.textState.getEndSelectionIndex();
    }

    public void setEndSelectionIndex(int endSelectionIndex) {
        this.textState.setEndSelectionIndex(endSelectionIndex);
    }

    public String getSelection() {
        return this.textState.getSelection();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        if (tabSize >= 1) {
            this.tabSize = tabSize;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAreaField textAreaField = (TextAreaField)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.textState, (Object)textAreaField.textState).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.textState).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("textState", (Object)this.textState).toString();
    }

    public float getMaxTextWidth() {
        return this.textState.getTextWidth();
    }

    public float getMaxTextHeight() {
        return this.textState.getTextHeight();
    }

    public Float getCaretX() {
        return this.textState.getCaretX();
    }

    public Float getCaretY() {
        return this.textState.getCaretY();
    }

    public boolean isStickToAlignment() {
        return this.stickToAlignment;
    }

    public void setStickToAlignment(boolean stickToAlignment) {
        this.stickToAlignment = stickToAlignment;
    }
}

