/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.event.slider.SliderChangeValueEvent;
import com.spinyowl.legui.component.misc.listener.slider.SliderMouseClickEventListener;
import com.spinyowl.legui.component.misc.listener.slider.SliderMouseDragEventListener;
import com.spinyowl.legui.component.misc.listener.slider.SliderScrollEventListener;
import com.spinyowl.legui.component.optional.Orientation;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.event.MouseDragEvent;
import com.spinyowl.legui.event.ScrollEvent;
import com.spinyowl.legui.intersection.Intersector;
import com.spinyowl.legui.intersection.RectangleIntersector;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.theme.Themes;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class Slider
extends Component {
    public static final float DEFAULT_MAX_VALUE = 100.0f;
    public static final float DEFAULT_MIN_VALUE = 0.0f;
    private float value = 0.0f;
    private Orientation orientation = Orientation.HORIZONTAL;
    private Vector4f sliderActiveColor = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
    private Vector4f sliderColor = new Vector4f(0.7f, 0.7f, 0.7f, 0.4f);
    private float sliderSize = 10.0f;
    private float minValue = 0.0f;
    private float maxValue = 100.0f;
    private float stepSize;

    public Slider(float value) {
        this.initialize(value);
    }

    public Slider(Vector2f position, Vector2f size, float value) {
        super(position, size);
        this.initialize(value);
    }

    public Slider(float x, float y, float width, float height, float value) {
        super(x, y, width, height);
        this.initialize(value);
    }

    public Slider() {
        this(0.0f);
    }

    public Slider(float x, float y, float width, float height) {
        this(x, y, width, height, 0.0f);
    }

    public Slider(Vector2f position, Vector2f size) {
        this(position, size, 0.0f);
    }

    private void initialize(float value) {
        this.value = value;
        this.getStyle().getBackground().setColor(ColorConstants.transparent());
        this.getStyle().setBorder(null);
        this.getListenerMap().addListener(ScrollEvent.class, new SliderScrollEventListener());
        this.getListenerMap().addListener(MouseClickEvent.class, new SliderMouseClickEventListener());
        this.getListenerMap().addListener(MouseDragEvent.class, new SliderMouseDragEventListener());
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(Slider.class).applyAll(this);
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        if (minValue > this.maxValue) {
            this.maxValue = minValue;
            return;
        }
        this.minValue = minValue;
        this.setStepSize(this.getStepSize());
        this.setValue(this.getValue());
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        if (maxValue < this.minValue) {
            this.minValue = maxValue;
            return;
        }
        this.maxValue = maxValue;
        this.setStepSize(this.getStepSize());
        this.setValue(this.getValue());
    }

    public float getStepSize() {
        return this.stepSize < 0.0f ? 0.0f : this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
        if (stepSize > 0.0f) {
            float difference = this.maxValue - this.minValue;
            this.stepSize = difference < stepSize ? difference : stepSize;
        }
        this.setValue(this.getValue());
    }

    @Override
    public void setIntersector(Intersector intersector) {
        if (!(intersector instanceof RectangleIntersector)) {
            return;
        }
        super.setIntersector(intersector);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        if (this.stepSize > 0.0f) {
            float halfStepSize = this.stepSize / 2.0f;
            if (this.value < 0.0f) {
                halfStepSize *= -1.0f;
            }
            int count = (int)((this.value + halfStepSize) / this.stepSize);
            this.value = this.stepSize * (float)count;
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        } else if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    public Vector4f getSliderColor() {
        return this.sliderColor;
    }

    public void setSliderColor(Vector4f sliderColor) {
        this.sliderColor = sliderColor;
    }

    public float getSliderSize() {
        return this.sliderSize;
    }

    public void setSliderSize(float sliderSize) {
        this.sliderSize = sliderSize;
    }

    public Vector4f getSliderActiveColor() {
        return this.sliderActiveColor;
    }

    public void setSliderActiveColor(Vector4f sliderActiveColor) {
        this.sliderActiveColor = sliderActiveColor;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void addSliderChangeValueEventListener(EventListener<SliderChangeValueEvent> eventListener) {
        this.getListenerMap().addListener(SliderChangeValueEvent.class, eventListener);
    }

    public List<EventListener<SliderChangeValueEvent>> getSliderChangeValueEvents() {
        return this.getListenerMap().getListeners(SliderChangeValueEvent.class);
    }

    public void removeSliderChangeValueEventListener(EventListener<SliderChangeValueEvent> eventListener) {
        this.getListenerMap().removeListener(SliderChangeValueEvent.class, eventListener);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slider slider = (Slider)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.value, slider.value).append(this.sliderSize, slider.sliderSize).append((Object)this.orientation, (Object)slider.orientation).append((Object)this.sliderActiveColor, (Object)slider.sliderActiveColor).append((Object)this.sliderColor, (Object)slider.sliderColor).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.value).append((Object)this.orientation).append((Object)this.sliderActiveColor).append((Object)this.sliderColor).append(this.sliderSize).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("value", this.value).append("orientation", (Object)this.orientation).append("sliderActiveColor", (Object)this.sliderActiveColor).append("sliderColor", (Object)this.sliderColor).append("sliderSize", this.sliderSize).toString();
    }
}

