/*
 * Decompiled with CFR 0.152.
 */
package com.spinyowl.legui.component;

import com.spinyowl.legui.component.Button;
import com.spinyowl.legui.component.Component;
import com.spinyowl.legui.component.Layer;
import com.spinyowl.legui.component.ScrollablePanel;
import com.spinyowl.legui.component.event.selectbox.SelectBoxChangeSelectionEvent;
import com.spinyowl.legui.component.event.selectbox.SelectBoxChangeSelectionEventListener;
import com.spinyowl.legui.component.misc.animation.selectbox.SelectBoxAnimation;
import com.spinyowl.legui.component.misc.listener.selectbox.SelectBoxClickListener;
import com.spinyowl.legui.component.misc.listener.selectbox.SelectBoxElementClickListener;
import com.spinyowl.legui.component.misc.listener.selectbox.SelectBoxFocusListener;
import com.spinyowl.legui.event.FocusEvent;
import com.spinyowl.legui.event.MouseClickEvent;
import com.spinyowl.legui.icon.CharIcon;
import com.spinyowl.legui.icon.Icon;
import com.spinyowl.legui.listener.EventListener;
import com.spinyowl.legui.style.Style;
import com.spinyowl.legui.style.color.ColorConstants;
import com.spinyowl.legui.style.flex.FlexStyle;
import com.spinyowl.legui.theme.Themes;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class SelectBox<T>
extends Component {
    public static final int EXPAND_ICON_CHAR = 58821;
    public static final int COLLAPSE_ICON_CHAR = 58823;
    public static final String DEFAULT_ICON_FONT = "MaterialIcons-Regular";
    private static final String NULL = "null";
    private Icon expandIcon;
    private Icon collapseIcon;
    private List<SelectBoxElement<T>> selectBoxElements = new CopyOnWriteArrayList<SelectBoxElement<T>>();
    private List<T> elements = new CopyOnWriteArrayList<T>();
    private SelectBoxScrollablePanel selectionListPanel = new SelectBoxScrollablePanel();
    private Button selectionButton = new Button("null");
    private T selectedElement = null;
    private float elementHeight = 16.0f;
    private float buttonWidth = 15.0f;
    private int visibleCount = 3;
    private Button expandButton = new Button("");
    private boolean collapsed = true;
    private Lock lock = new ReentrantLock(false);
    private SelectBoxLayer selectBoxLayer = new SelectBoxLayer();

    public SelectBox() {
        this.initialize();
    }

    public SelectBox(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.initialize();
    }

    public SelectBox(Vector2f position, Vector2f size) {
        super(position, size);
        this.initialize();
    }

    public List<T> getElements() {
        return this.elements;
    }

    public float getButtonWidth() {
        return this.buttonWidth;
    }

    public void setButtonWidth(float buttonWidth) {
        this.buttonWidth = buttonWidth;
    }

    public T getSelection() {
        return this.selectedElement;
    }

    private void initialize() {
        this.selectionListPanel.setHorizontalScrollBarVisible(false);
        this.selectionListPanel.getContainer().getStyle().setDisplay(Style.DisplayType.FLEX);
        this.selectionListPanel.getContainer().getStyle().getFlexStyle().setFlexDirection(FlexStyle.FlexDirection.COLUMN);
        this.selectionListPanel.getContainer().getStyle().getBackground().setColor(ColorConstants.lightBlue());
        this.getStyle().setDisplay(Style.DisplayType.FLEX);
        this.expandIcon = new CharIcon(new Vector2f((Vector2fc)this.expandButton.getSize()), DEFAULT_ICON_FONT, '\ue5c5', ColorConstants.black());
        this.collapseIcon = new CharIcon(new Vector2f((Vector2fc)this.expandButton.getSize()), DEFAULT_ICON_FONT, '\ue5c7', ColorConstants.black());
        this.expandButton.getStyle().getBackground().setIcon(this.expandIcon);
        this.expandButton.getStyle().setMinimumSize(this.buttonWidth, 0.0f);
        this.expandButton.getStyle().setMaximumSize(this.buttonWidth, Float.MAX_VALUE);
        this.expandButton.getStyle().setRight(0.0f);
        this.expandButton.getStyle().setTop(0.0f);
        this.expandButton.getStyle().setBottom(0.0f);
        this.selectionButton.getStyle().setTop(0.0f);
        this.selectionButton.getStyle().setLeft(0.0f);
        this.selectionButton.getStyle().setBottom(0.0f);
        this.selectionButton.getStyle().setRight(this.buttonWidth);
        this.add(this.expandButton);
        this.add(this.selectionButton);
        SelectBoxClickListener mouseClickEventListener = new SelectBoxClickListener(this);
        this.selectionButton.getListenerMap().addListener(MouseClickEvent.class, mouseClickEventListener);
        this.expandButton.getListenerMap().addListener(MouseClickEvent.class, mouseClickEventListener);
        this.selectBoxLayer.getListenerMap().addListener(MouseClickEvent.class, mouseClickEventListener);
        SelectBoxFocusListener focusEventListener = new SelectBoxFocusListener(this);
        this.selectionListPanel.getVerticalScrollBar().getListenerMap().getListeners(FocusEvent.class).add(focusEventListener);
        this.selectionButton.getListenerMap().getListeners(FocusEvent.class).add(focusEventListener);
        this.expandButton.getListenerMap().getListeners(FocusEvent.class).add(focusEventListener);
        this.selectBoxLayer.add(this.selectionListPanel);
        SelectBoxAnimation animation = new SelectBoxAnimation(this, this.selectionListPanel);
        animation.startAnimation();
        Themes.getDefaultTheme().getThemeManager().getComponentTheme(SelectBox.class).applyAll(this);
    }

    public Icon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(Icon collapseIcon) {
        this.collapseIcon = collapseIcon;
        this.updateIcons();
    }

    public Icon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(Icon expandIcon) {
        this.expandIcon = expandIcon;
        this.updateIcons();
    }

    private void updateIcons() {
        this.expandButton.getStyle().getBackground().setIcon(this.collapsed ? this.expandIcon : this.collapseIcon);
    }

    public Button getExpandButton() {
        return this.expandButton;
    }

    public Button getSelectionButton() {
        return this.selectionButton;
    }

    public SelectBoxScrollablePanel getSelectionListPanel() {
        return this.selectionListPanel;
    }

    public int getVisibleCount() {
        return this.visibleCount;
    }

    public void setVisibleCount(int visibleCount) {
        this.visibleCount = visibleCount;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        if (!collapsed) {
            this.selectionListPanel.getVerticalScrollBar().setCurValue(0.0f);
        }
    }

    private void resize() {
        this.updateIcons();
        for (SelectBoxElement<T> selectBoxElement : this.selectBoxElements) {
            selectBoxElement.getStyle().setMinimumSize(0.0f, this.elementHeight);
        }
    }

    public void addElement(T element) {
        this.lock.lock();
        try {
            if (!this.elements.contains(element)) {
                SelectBoxElement<T> boxElement = this.createSelectBoxElement(element);
                if (this.elements.isEmpty()) {
                    this.selectedElement = element;
                    this.selectionButton.getTextState().setText(element == null ? NULL : element.toString());
                }
                this.elements.add(element);
                this.selectBoxElements.add(boxElement);
                this.selectionListPanel.getContainer().add(boxElement);
                this.selectionListPanel.getContainer().getSize().y = (float)this.selectBoxElements.size() * this.elementHeight;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private SelectBoxElement<T> createSelectBoxElement(T element) {
        SelectBoxElement<T> boxElement = new SelectBoxElement<T>(element, false);
        boxElement.getStyle().setHeight(this.elementHeight);
        boxElement.getStyle().setMinHeight(this.elementHeight);
        boxElement.getStyle().setPosition(Style.PositionType.RELATIVE);
        boxElement.getListenerMap().getListeners(MouseClickEvent.class).add(new SelectBoxElementClickListener(this));
        return boxElement;
    }

    public int getElementIndex(T element) {
        return this.elements.indexOf(element);
    }

    public void removeElement(T element) {
        this.removeElement(this.elements.indexOf(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(int index) {
        this.lock.lock();
        try {
            if (!this.elements.isEmpty()) {
                T s = this.elements.get(index);
                this.elements.remove(index);
                SelectBoxElement<T> element = this.selectBoxElements.get(index);
                this.selectBoxElements.remove(index);
                this.selectionListPanel.getContainer().remove(element);
                for (int i = index; i < this.selectBoxElements.size(); ++i) {
                    this.selectBoxElements.get((int)i).getPosition().y -= this.elementHeight;
                }
                if (this.selectedElement == s) {
                    this.setSelected(0, true);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSelected(T element, boolean selected) {
        int index = this.elements.indexOf(element);
        this.setSelected(element, selected, index);
    }

    public void setSelected(int index, boolean selected) {
        if (this.elements.isEmpty()) {
            this.selectedElement = null;
            this.selectionButton.getTextState().setText(NULL);
        } else {
            T element = this.elements.get(index);
            this.setSelected(element, selected, index);
        }
    }

    private void setSelected(T element, boolean selected, int index) {
        if (selected) {
            if (index != -1) {
                SelectBoxElement<T> tSelectBoxElement = this.selectBoxElements.get(index);
                tSelectBoxElement.selected = true;
                int selectedIndex = this.elements.indexOf(this.selectedElement);
                if (selectedIndex != -1) {
                    this.selectBoxElements.get((int)index).selected = false;
                }
                this.selectedElement = element;
                this.selectionButton.getTextState().setText(element == null ? NULL : element.toString());
            } else {
                this.addElement(element);
                this.setSelected(element, true);
            }
        } else if (index != -1) {
            this.selectBoxElements.get((int)index).selected = false;
            if (Objects.equals(element, this.selectedElement)) {
                this.selectionButton.getTextState().setText(NULL);
            }
        } else {
            this.addElement(element);
        }
    }

    public float getElementHeight() {
        return this.elementHeight;
    }

    public void setElementHeight(float elementHeight) {
        this.elementHeight = elementHeight;
        this.resize();
    }

    public void addSelectBoxChangeSelectionEventListener(EventListener<SelectBoxChangeSelectionEvent<T>> eventListener) {
        this.getListenerMap().addListener(SelectBoxChangeSelectionEvent.class, eventListener);
    }

    public List<EventListener<SelectBoxChangeSelectionEvent<T>>> getSelectBoxChangeSelectionEvents() {
        return (List)List.class.cast(this.getListenerMap().getListeners(SelectBoxChangeSelectionEvent.class));
    }

    public void removeSelectBoxChangeSelectionEventListener(SelectBoxChangeSelectionEventListener<T> eventListener) {
        this.getListenerMap().removeListener(SelectBoxChangeSelectionEvent.class, eventListener);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("elements", this.elements).append("selectedElement", this.selectedElement).append("elementHeight", this.elementHeight).append("buttonWidth", this.buttonWidth).append("visibleCount", this.visibleCount).append("collapsed", this.collapsed).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectBox selectBox = (SelectBox)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.elementHeight, selectBox.elementHeight).append(this.buttonWidth, selectBox.buttonWidth).append(this.visibleCount, selectBox.visibleCount).append(this.collapsed, selectBox.collapsed).append(this.selectBoxElements, selectBox.selectBoxElements).append(this.elements, selectBox.elements).append((Object)this.selectionListPanel, (Object)selectBox.selectionListPanel).append((Object)this.selectionButton, (Object)selectBox.selectionButton).append(this.selectedElement, selectBox.selectedElement).append((Object)this.expandButton, (Object)selectBox.expandButton).isEquals();
    }

    public List<SelectBoxElement<T>> getSelectBoxElements() {
        return this.selectBoxElements;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.selectBoxElements).append(this.elements).append((Object)this.selectionListPanel).append((Object)this.selectionButton).append(this.selectedElement).append(this.elementHeight).append(this.buttonWidth).append(this.visibleCount).append((Object)this.expandButton).append(this.collapsed).toHashCode();
    }

    public SelectBoxLayer getSelectBoxLayer() {
        return this.selectBoxLayer;
    }

    public class SelectBoxScrollablePanel
    extends ScrollablePanel {
    }

    public static class SelectBoxLayer
    extends Layer {
        public SelectBoxLayer() {
            this.setEventPassable(true);
            this.setEventReceivable(true);
        }
    }

    public class SelectBoxElement<T>
    extends Button {
        private boolean selected;
        private T object;

        private SelectBoxElement(T object, boolean selected) {
            super(object == null ? SelectBox.NULL : object.toString());
            this.selected = selected;
            this.object = object;
            this.getStyle().setBorder(null);
            Themes.getDefaultTheme().apply(this);
        }

        public T getObject() {
            return this.object;
        }

        public boolean isSelected() {
            return this.selected;
        }

        private void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("selected", this.selected).toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectBoxElement that = (SelectBoxElement)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append(this.selected, that.selected).append(this.object, that.object).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.selected).toHashCode();
        }
    }
}

